/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.gsp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.granite.generator.gsp.ParseException;
import org.granite.generator.gsp.token.Comment;
import org.granite.generator.gsp.token.Declaration;
import org.granite.generator.gsp.token.Directive;
import org.granite.generator.gsp.token.Expression;
import org.granite.generator.gsp.token.Scriplet;
import org.granite.generator.gsp.token.TemplateText;
import org.granite.generator.gsp.token.Token;

public class Parser {
    private final List<Token> elements = new ArrayList<Token>();

    public List<Token> parse(Reader reader) throws IOException, ParseException {
        if (reader == null) {
            throw new NullPointerException("reader cannot be null");
        }
        if (!(reader instanceof StringReader) && !(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        return this.parse(this.read(reader));
    }

    public List<Token> getElements() {
        return this.elements;
    }

    public void reset() {
        this.elements.clear();
    }

    private List<Token> parse(String template) throws ParseException {
        if (template == null) {
            throw new NullPointerException("Argument template cannot be null");
        }
        StringBuilder sb = new StringBuilder(64);
        int length = template.length();
        boolean inText = true;
        for (int i = 0; i < length; ++i) {
            char first = inText ? (char)'<' : '%';
            char last = inText ? (char)'%' : '>';
            char c = template.charAt(i);
            boolean appendC = true;
            if (c == first && i + 1 < length) {
                c = template.charAt(i + 1);
                if (c == last) {
                    if (inText) {
                        this.addTemplateText(i - sb.length(), sb.toString());
                    } else {
                        this.addScriptingElement(i - sb.length() - 2, sb.toString());
                    }
                    sb.setLength(0);
                    inText = !inText;
                    appendC = false;
                    ++i;
                } else if (c == '\\') {
                    sb.append(first);
                    i += 2;
                    while (i < length && (c = template.charAt(i)) == '\\') {
                        sb.append(c);
                        ++i;
                    }
                    if (c != last) {
                        sb.append('\\');
                    }
                } else {
                    c = first;
                }
            }
            if (!appendC) continue;
            sb.append(c);
        }
        if (!inText) {
            throw new ParseException("Missing script section end (\"%>\")");
        }
        this.addTemplateText(length - sb.length(), sb.toString());
        return this.elements;
    }

    private String read(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        int pc = -1;
        int c = -1;
        while ((c = reader.read()) != -1) {
            switch (c) {
                case 13: {
                    break;
                }
                case 10: {
                    sb.append('\n');
                    break;
                }
                default: {
                    if (pc == 13) {
                        sb.append('\n');
                    }
                    sb.append((char)c);
                }
            }
            pc = c;
        }
        return sb.toString();
    }

    private void addTemplateText(int index, String text) {
        if (text.length() > 0) {
            this.elements.add(new TemplateText(index, text));
        }
    }

    private void addScriptingElement(int index, String text) throws ParseException {
        if (text.length() == 0) {
            return;
        }
        char first = text.charAt(0);
        switch (first) {
            case '=': {
                this.elements.add(new Expression(index, text.substring(1).trim()));
                break;
            }
            case '!': {
                this.elements.add(new Declaration(index, text.substring(1).trim()));
                break;
            }
            case '@': {
                this.elements.add(new Directive(index, text.substring(1).trim()));
                break;
            }
            case '-': {
                if (text.startsWith("--") && text.endsWith("--")) {
                    this.elements.add(new Comment(index, text.substring(2, text.length() - 4)));
                    break;
                }
            }
            default: {
                this.elements.add(new Scriplet(index, text));
            }
        }
    }
}

