/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.java;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.PackageTranslator;

public class JavaType
implements ClientType {
    public static final JavaType BOOLEAN = new JavaType(null, "boolean", false);
    public static final JavaType INT = new JavaType(null, "int", 0);
    public static final JavaType LONG = new JavaType(null, "long", 0L);
    public static final JavaType FLOAT = new JavaType(null, "float", Float.valueOf(0.0f));
    public static final JavaType DOUBLE = new JavaType(null, "double", 0.0);
    public static final JavaType STRING = new JavaType(null, "String", null);
    public static final JavaType PAGE_INFO = new JavaType("org.granite.tide.data.model", "PageInfo", null);
    public static final JavaType SORT_INFO = new JavaType("org.granite.tide.data.model", "SortInfo", null);
    public static final JavaType LAZY = new JavaType("org.granite.client.persistence", "Lazy", null);
    private final String packageName;
    private final String name;
    private final String qualifiedName;
    private final String propertyImplTypeName;
    private final Object nullValue;
    private final Set<String> imports = new HashSet<String>();

    public JavaType(String packageName, String simpleName) {
        this(packageName, simpleName, null, null);
    }

    public JavaType(String packageName, String name, Object nullValue) {
        this(packageName, name, null, nullValue);
    }

    public JavaType(String packageName, String name, String propertyImplTypeName, Object nullValue) {
        this.packageName = packageName != null ? packageName : "";
        this.name = name;
        this.qualifiedName = this.hasPackage() ? packageName + '.' + name : name;
        this.nullValue = nullValue;
        this.propertyImplTypeName = propertyImplTypeName;
        if (this.hasPackage()) {
            this.imports.add(this.ungenerify(this.qualifiedName));
        }
        if (propertyImplTypeName != null) {
            this.imports.add(this.ungenerify(propertyImplTypeName));
        }
    }

    @Override
    public boolean hasPackage() {
        return this.packageName.length() > 0;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getPropertyImplTypeName() {
        return this.propertyImplTypeName;
    }

    public String getSimplePropertyImplTypeName() {
        return this.propertyImplTypeName != null && this.propertyImplTypeName.indexOf(".") >= 0 ? this.propertyImplTypeName.substring(this.propertyImplTypeName.lastIndexOf(".") + 1) : this.propertyImplTypeName;
    }

    @Override
    public Object getNullValue() {
        return this.nullValue;
    }

    public boolean isNumber() {
        return false;
    }

    @Override
    public Set<String> getImports() {
        return this.imports;
    }

    @Override
    public void addImports(Set<String> classNames) {
        for (String className : classNames) {
            if (className.indexOf(".") < 0 || className.startsWith("java.lang")) continue;
            this.imports.add(this.ungenerify(className));
        }
    }

    private String ungenerify(String className) {
        if (className.indexOf("<") >= 0) {
            return className.substring(0, className.indexOf("<"));
        }
        return className;
    }

    @Override
    public JavaType toArrayType() {
        return new JavaType(this.packageName, this.name + "[]", null);
    }

    @Override
    public JavaType translatePackage(PackageTranslator translator) {
        return new JavaType(translator.translate(this.packageName), this.getName(), this.getPropertyImplTypeName(), this.getNullValue());
    }

    @Override
    public JavaType translatePackages(List<PackageTranslator> translators) {
        boolean translate = false;
        PackageTranslator translator = PackageTranslator.forPackage(translators, this.packageName);
        String translatedPackageName = this.packageName;
        if (translator != null) {
            translate = true;
            translatedPackageName = translator.translate(this.packageName);
        }
        HashSet<String> translatedImports = new HashSet<String>();
        for (String imp : this.imports) {
            translator = PackageTranslator.forPackage(translators, imp);
            if (translator != null) {
                translate = true;
                translatedImports.add(translator.translate(imp));
                continue;
            }
            translatedImports.add(imp);
        }
        if (!translate) {
            return this;
        }
        JavaType translatedType = new JavaType(translatedPackageName, this.getName(), this.getPropertyImplTypeName(), this.getNullValue());
        translatedType.addImports(translatedImports);
        return translatedType;
    }

    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JavaType)) {
            return false;
        }
        return this.qualifiedName.equals(((JavaType)obj).qualifiedName);
    }

    public String toString() {
        return this.qualifiedName;
    }
}

