/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.granite.config.GraniteConfig;
import org.granite.config.ShutdownListener;
import org.granite.config.flex.Destination;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.context.SimpleGraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.adapters.AdapterFactory;
import org.granite.gravity.adapters.ServiceAdapter;
import org.granite.gravity.security.GravityDestinationSecurizer;
import org.granite.gravity.security.GravityInvocationContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.util.UUIDUtil;

public class Gravity
implements ShutdownListener {
    private static final Logger log = Logger.getLogger(Gravity.class);
    private static final String RECONNECT_INTERVAL_MS_KEY = "reconnect-interval-ms";
    private static final String RECONNECT_MAX_ATTEMPTS_KEY = "reconnect-max-attempts";
    private final ChannelFactory channelFactory;
    private final ServicesConfig servicesConfig;
    private final GraniteConfig graniteConfig;
    private final Map<String, Object> applicationMap = new HashMap<String, Object>();
    private final ConcurrentHashMap<String, AbstractChannel> channels = new ConcurrentHashMap();
    private AdapterFactory adapterFactory = null;
    private transient Timer clientTimer;
    private long clientTimeoutMs = 1800000L;
    private boolean initialized;
    private transient Random random;
    private long reconnectIntervalMs = 30000L;
    private long reconnectMaxAttempts = 60L;

    public Gravity(ChannelFactory channelFactory, ServicesConfig servicesConfig, GraniteConfig graniteConfig) {
        if (channelFactory == null || servicesConfig == null || graniteConfig == null) {
            throw new NullPointerException("All arguments must be non null.");
        }
        this.channelFactory = channelFactory;
        this.servicesConfig = servicesConfig;
        this.graniteConfig = graniteConfig;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public GraniteConfig getGraniteConfig() {
        return this.graniteConfig;
    }

    public long getClientTimeoutMs() {
        return this.clientTimeoutMs;
    }

    public void setClientTimeoutMs(long ms) {
        this.clientTimeoutMs = ms;
    }

    public long getReconnectIntervalMs() {
        return this.reconnectIntervalMs;
    }

    public void setReconnectIntervalMs(long ms) {
        this.reconnectIntervalMs = ms;
    }

    public long getReconnectMaxAttempts() {
        return this.reconnectMaxAttempts;
    }

    public void setReconnectMaxAttempts(long reconnectMaxAttempts) {
        this.reconnectMaxAttempts = reconnectMaxAttempts;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Gravity gravity = this;
        synchronized (gravity) {
            this.adapterFactory = new AdapterFactory(this);
            try {
                this.random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (Exception e) {
                log.error((Throwable)e, "Could not get secure random for ID generation", new Object[0]);
                this.random = new Random();
            }
            this.random.setSeed(this.random.nextLong() ^ (long)this.hashCode() ^ (long)(this.hashCode() << 32) ^ Runtime.getRuntime().freeMemory());
            this.clientTimer = new Timer();
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Gravity gravity = this;
        synchronized (gravity) {
            this.adapterFactory.stopAll();
            this.channelFactory.stop();
            this.initialized = false;
        }
    }

    public String registerChannel(AbstractChannel channel) {
        String clientId = UUIDUtil.randomUUID();
        int i = 0;
        while (this.channels.putIfAbsent(clientId, channel) != null) {
            clientId = UUIDUtil.randomUUID();
            if (i >= 10) {
                throw new RuntimeException("Could not find random new clientId after 10 iterations");
            }
            ++i;
        }
        return clientId;
    }

    public AbstractChannel getChannel(String channelId) {
        if (channelId == null) {
            return null;
        }
        return this.channels.get(channelId);
    }

    public AbstractChannel removeChannel(String channelId) {
        if (channelId == null) {
            return null;
        }
        AbstractChannel channel = this.channels.remove(channelId);
        if (channel != null) {
            channel.unsubscribeAll();
        }
        return channel;
    }

    /*
     * Exception decompiling
     */
    public Message handleMessage(Message message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Message handlePingMessage(CommandMessage message) {
        AbstractChannel client = this.channelFactory.newRemoteChannel(this);
        AcknowledgeMessage reply = null;
        if (client != null) {
            reply = new AcknowledgeMessage((Message)message);
            reply.setClientId((Object)client.getClientId());
            HashMap<String, Long> advice = new HashMap<String, Long>();
            advice.put(RECONNECT_INTERVAL_MS_KEY, this.getReconnectIntervalMs());
            advice.put(RECONNECT_MAX_ATTEMPTS_KEY, this.getReconnectMaxAttempts());
            reply.setBody(advice);
        } else {
            reply = new ErrorMessage((Message)message, true);
        }
        reply.setDestination(message.getDestination());
        log.debug("handshake.handle: reply=%s", new Object[]{reply});
        return reply;
    }

    private Message handleSecurityMessage(CommandMessage message) {
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        AcknowledgeMessage response = null;
        if (!config.hasSecurityService()) {
            log.warn("Ignored security operation (no security settings in granite-config.xml): %s", new Object[]{message});
        } else {
            SecurityService securityService = config.getSecurityService();
            try {
                if (message.isLoginOperation()) {
                    securityService.login(message.getBody());
                } else {
                    securityService.logout();
                }
            }
            catch (Exception e) {
                if (e instanceof SecurityServiceException) {
                    log.debug((Throwable)e, "Could not process security operation: %s", new Object[]{message});
                } else {
                    log.error((Throwable)e, "Could not process security operation: %s", new Object[]{message});
                }
                response = new ErrorMessage((Message)message, (Throwable)e, true);
            }
        }
        if (response == null) {
            response = new AcknowledgeMessage((Message)message, true);
            if (message.isSecurityOperation()) {
                response.setBody((Object)"success");
            }
        }
        return response;
    }

    private Message handleConnectMessage(CommandMessage message) {
        AbstractChannel client = this.getChannel((String)message.getClientId());
        if (client == null) {
            return this.handleUnknownClientMessage((Message)message);
        }
        ErrorMessage reply = null;
        if (!client.connect()) {
            reply = new ErrorMessage((Message)message, true);
            reply.setFaultString("Could not connect client: " + client);
            reply.setDestination(message.getDestination());
        }
        return reply;
    }

    private Message handleDisconnectMessage(CommandMessage message) {
        AbstractChannel client = this.getChannel((String)message.getClientId());
        if (client == null) {
            return this.handleUnknownClientMessage((Message)message);
        }
        this.removeChannel(client.getClientId());
        AcknowledgeMessage reply = new AcknowledgeMessage((Message)message);
        reply.setDestination(message.getDestination());
        reply.setClientId((Object)client.getClientId());
        return reply;
    }

    private Message handleSubscribeMessage(CommandMessage message) {
        AbstractChannel client;
        GraniteConfig config;
        GraniteContext context = GraniteContext.getCurrentInstance();
        Destination destination = context.getServicesConfig().findDestinationById(message.getMessageRefType(), message.getDestination());
        if (destination == null) {
            return this.getInvalidDestinationError((Message)message);
        }
        GravityInvocationContext invocationContext = new GravityInvocationContext((Message)message, destination);
        if (destination.getSecurizer() instanceof GravityDestinationSecurizer) {
            try {
                ((GravityDestinationSecurizer)destination.getSecurizer()).canSubscribe(invocationContext);
            }
            catch (Exception e) {
                return new ErrorMessage((Message)message, (Throwable)e);
            }
        }
        if ((config = context.getGraniteConfig()).hasSecurityService()) {
            try {
                config.getSecurityService().authorize((AbstractSecurityContext)invocationContext);
            }
            catch (Exception e) {
                return new ErrorMessage((Message)message, (Throwable)e);
            }
        }
        if ((client = this.getChannel((String)message.getClientId())) == null) {
            return this.handleUnknownClientMessage((Message)message);
        }
        String subscriptionId = (String)message.getHeader("DSDstClientId");
        if (subscriptionId == null) {
            subscriptionId = UUIDUtil.randomUUID();
            message.setHeader("DSDstClientId", (Object)subscriptionId);
        }
        ServiceAdapter adapter = this.adapterFactory.getServiceAdapter((Message)message);
        AsyncMessage reply = (AsyncMessage)adapter.manage(client, message);
        reply.setDestination(message.getDestination());
        reply.setClientId((Object)client.getClientId());
        reply.getHeaders().putAll(message.getHeaders());
        return reply;
    }

    private Message handleUnsubscribeMessage(CommandMessage message) {
        AbstractChannel client = this.getChannel((String)message.getClientId());
        if (client == null) {
            return this.handleUnknownClientMessage((Message)message);
        }
        AcknowledgeMessage reply = null;
        ServiceAdapter adapter = this.adapterFactory.getServiceAdapter((Message)message);
        reply = (AcknowledgeMessage)adapter.manage(client, message);
        reply.setDestination(message.getDestination());
        reply.setClientId((Object)client.getClientId());
        reply.getHeaders().putAll(message.getHeaders());
        return reply;
    }

    private Message handlePublishMessage(Message message) {
        AbstractChannel client;
        GraniteConfig config;
        GraniteContext context = GraniteContext.getCurrentInstance();
        Destination destination = context.getServicesConfig().findDestinationById(message.getClass().getName(), message.getDestination());
        if (destination == null) {
            return this.getInvalidDestinationError(message);
        }
        GravityInvocationContext invocationContext = new GravityInvocationContext(message, destination);
        if (destination.getSecurizer() instanceof GravityDestinationSecurizer) {
            try {
                ((GravityDestinationSecurizer)destination.getSecurizer()).canPublish(invocationContext);
            }
            catch (Exception e) {
                return new ErrorMessage(message, (Throwable)e, true);
            }
        }
        if ((config = context.getGraniteConfig()).hasSecurityService()) {
            try {
                config.getSecurityService().authorize((AbstractSecurityContext)invocationContext);
            }
            catch (Exception e) {
                return new ErrorMessage(message, (Throwable)e, true);
            }
        }
        if ((client = this.getChannel((String)message.getClientId())) == null) {
            return this.handleUnknownClientMessage(message);
        }
        ServiceAdapter adapter = this.adapterFactory.getServiceAdapter(message);
        AsyncMessage reply = (AsyncMessage)adapter.invoke(client, message);
        reply.setDestination(message.getDestination());
        reply.setClientId((Object)client.getClientId());
        return reply;
    }

    private Message handleUnknownClientMessage(Message message) {
        ErrorMessage reply = new ErrorMessage(message, true);
        reply.setFaultCode("Server.Call.UnknownClient");
        reply.setFaultString("Unknown client");
        return reply;
    }

    public GraniteContext initThread() {
        GraniteContext context = GraniteContext.getCurrentInstance();
        if (context == null) {
            context = SimpleGraniteContext.createThreadIntance((GraniteConfig)this.graniteConfig, (ServicesConfig)this.servicesConfig, this.applicationMap);
        }
        return context;
    }

    public void publishMessage(AbstractChannel fromChannel, Message message) {
        GraniteContext context = this.initThread();
        Destination destination = context.getServicesConfig().findDestinationById(message.getClass().getName(), message.getDestination());
        if (destination == null) {
            throw new ServiceException("Invalid destination");
        }
        ServiceAdapter adapter = this.adapterFactory.getServiceAdapter(message);
        adapter.invoke(fromChannel, message);
    }

    public void scheduleChannelTimeout(TimerTask task) {
        this.clientTimer.schedule(task, this.getClientTimeoutMs());
    }

    private ErrorMessage getInvalidDestinationError(Message message) {
        String messageType = message.getClass().getName();
        if (message instanceof CommandMessage) {
            messageType = String.valueOf(messageType) + '[' + ((CommandMessage)message).getMessageRefType() + ']';
        }
        ErrorMessage reply = new ErrorMessage(message, true);
        reply.setFaultCode("Server.Messaging.InvalidDestination");
        reply.setFaultString("No configured destination for id: " + message.getDestination() + " and message type: " + messageType);
        return reply;
    }
}

