/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import flex.messaging.messages.Message;
import java.lang.reflect.Constructor;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.adapters.Topic;
import org.granite.gravity.selector.GravityMessageSelector;
import org.granite.gravity.selector.MessageSelector;

public class Subscriber {
    private final AbstractChannel client;
    private final Topic topic;
    private final String subscriptionId;
    private MessageSelector selector;

    public Subscriber(AbstractChannel client, Topic topic, String subscriptionId) {
        this.client = client;
        this.topic = topic;
        this.subscriptionId = subscriptionId;
    }

    public AbstractChannel getClient() {
        return this.client;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSelector(String selector) {
        if (selector != null) {
            try {
                GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
                Constructor messageSelectorConstructor = config.getMessageSelectorConstructor();
                this.selector = messageSelectorConstructor == null ? new GravityMessageSelector(selector) : (MessageSelector)messageSelectorConstructor.newInstance(selector);
            }
            catch (Exception e) {
                throw new RuntimeException("Selector", e);
            }
        }
    }

    public boolean deliver(AbstractChannel fromClient, Message message) {
        if (this.selector == null || this.selector.accept(message)) {
            this.getClient().deliver(fromClient, message, this.getSubscriptionId());
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!o.getClass().equals(Subscriber.class)) {
            return false;
        }
        Subscriber s = (Subscriber)o;
        return this.getClient().equals(s.getClient()) && this.getSubscriptionId().equals(s.getSubscriptionId());
    }

    public String toString() {
        return this.topic != null ? this.topic.toString() : "null topic";
    }
}

