/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.Subscriber;
import org.granite.gravity.adapters.SimpleServiceAdapter;
import org.granite.gravity.adapters.TopicId;
import org.granite.gravity.util.ArrayUtil;

public class Topic {
    private final TopicId id;
    private final SimpleServiceAdapter serviceAdapter;
    private Subscriber[] subscribers = new Subscriber[0];
    private ConcurrentMap<String, Topic> children = new ConcurrentHashMap<String, Topic>();
    private Topic wild;
    private Topic wildWild;
    private boolean persistent;

    public Topic(String topicId, SimpleServiceAdapter serviceAdapter) {
        this.id = new TopicId(topicId);
        this.serviceAdapter = serviceAdapter;
    }

    public String getId() {
        return this.id.toString();
    }

    public String toString() {
        return this.id.toString();
    }

    public TopicId getTopicId() {
        return this.id;
    }

    public Topic getChild(TopicId topicId) {
        String next = topicId.getSegment(this.id.depth());
        if (next == null) {
            return null;
        }
        Topic topic = (Topic)this.children.get(next);
        if (topic == null || topic.getTopicId().depth() == topicId.depth()) {
            return topic;
        }
        return topic.getChild(topicId);
    }

    public void addChild(Topic topic) {
        TopicId child = topic.getTopicId();
        if (!this.id.isParentOf(child)) {
            throw new IllegalArgumentException(this.id + " not parent of " + child);
        }
        String next = child.getSegment(this.id.depth());
        if (child.depth() - this.id.depth() == 1) {
            Topic old = this.children.putIfAbsent(next, topic);
            if (old != null) {
                throw new IllegalArgumentException("Already Exists");
            }
            if ("*".equals(next)) {
                this.wild = topic;
            } else if ("**".equals(next)) {
                this.wildWild = topic;
            }
        } else {
            Topic branch = (Topic)this.children.get(next);
            branch = this.serviceAdapter.getTopic(String.valueOf(this.id.depth() == 0 ? "/" : String.valueOf(this.id.toString()) + "/") + next, true);
            branch.addChild(topic);
        }
    }

    public String[] getSubscriberIds() {
        String[] ids = new String[this.subscribers.length];
        int i = 0;
        while (i < this.subscribers.length) {
            ids[i] = this.subscribers[i].getClient().getClientId();
            ++i;
        }
        return ids;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean remove() {
        return this.serviceAdapter.removeChannel(this.getTopicId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(AbstractChannel client, String subscriptionId, String selector) {
        Topic topic = this;
        synchronized (topic) {
            Subscriber subscriber = new Subscriber(client, this, subscriptionId);
            Subscriber[] subscriberArray = this.subscribers;
            int n = this.subscribers.length;
            int n2 = 0;
            while (n2 < n) {
                Subscriber s = subscriberArray[n2];
                if (subscriber.equals(s)) {
                    s.setSelector(selector);
                    return;
                }
                ++n2;
            }
            subscriber.setSelector(selector);
            this.subscribers = (Subscriber[])ArrayUtil.addToArray(this.subscribers, subscriber);
            client.addSubscription(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(AbstractChannel client, String subscriptionId) {
        Topic topic = this;
        synchronized (topic) {
            Subscriber subscriber = new Subscriber(client, this, subscriptionId);
            client.removeSubscription(subscriber);
            this.subscribers = (Subscriber[])ArrayUtil.removeFromArray(this.subscribers, subscriber);
            if (!this.persistent && this.subscribers.length == 0 && this.children.size() == 0) {
                this.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(TopicId to, AbstractChannel fromClient, Message msg) {
        int tail = to.depth() - this.id.depth();
        switch (tail) {
            case 0: {
                Subscriber[] subscribers;
                Topic topic = this;
                synchronized (topic) {
                    subscribers = this.subscribers;
                }
                Subscriber[] subscriberArray = subscribers;
                int n = subscribers.length;
                int n2 = 0;
                while (n2 < n) {
                    Subscriber subscriber = subscriberArray[n2];
                    Message m = ((AsyncMessage)msg).clone();
                    subscriber.deliver(fromClient, m);
                    ++n2;
                }
                break;
            }
            case 1: {
                Message m;
                int n;
                int n3;
                Subscriber[] subscriberArray;
                Subscriber[] subscribers;
                Object subscriber;
                if (this.wild != null) {
                    subscriber = this.wild;
                    synchronized (subscriber) {
                        subscribers = this.wild.subscribers;
                    }
                    subscriberArray = subscribers;
                    n3 = subscribers.length;
                    n = 0;
                    while (n < n3) {
                        subscriber = subscriberArray[n];
                        m = ((AsyncMessage)msg).clone();
                        ((Subscriber)subscriber).deliver(fromClient, m);
                        ++n;
                    }
                }
            }
            default: {
                String next;
                Topic topic;
                Message m;
                int n;
                int n3;
                Subscriber[] subscriberArray;
                Subscriber[] subscribers;
                Object subscriber;
                if (this.wildWild != null) {
                    subscriber = this.wildWild;
                    synchronized (subscriber) {
                        subscribers = this.wildWild.subscribers;
                    }
                    subscriberArray = subscribers;
                    n3 = subscribers.length;
                    n = 0;
                    while (n < n3) {
                        subscriber = subscriberArray[n];
                        m = ((AsyncMessage)msg).clone();
                        ((Subscriber)subscriber).deliver(fromClient, m);
                        ++n;
                    }
                }
                if ((topic = (Topic)this.children.get(next = to.getSegment(this.id.depth()))) == null) break;
                topic.publish(to, fromClient, msg);
            }
        }
    }
}

