/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty;

import flex.messaging.messages.Message;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.Gravity;
import org.granite.logging.Logger;
import org.mortbay.util.ajax.Continuation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuationChannel
extends AbstractChannel {
    private static final Logger log = Logger.getLogger(ContinuationChannel.class);
    private transient Continuation continuation;
    private final AtomicInteger responsesPending = new AtomicInteger(0);
    private Queue<Message> messageQ = new LinkedList<Message>();

    ContinuationChannel(Gravity gravity) {
        super(gravity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContinuation(Continuation continuation) {
        ContinuationChannel continuationChannel = this;
        synchronized (continuationChannel) {
            if (this.continuation != null && this.continuation.isPending()) {
                log.debug("Set pending continuation for client: %s", new Object[]{this.getClientId()});
                this.continuation.resume();
            }
            this.continuation = continuation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ContinuationChannel continuationChannel = this;
        synchronized (continuationChannel) {
            if (this.continuation != null) {
                log.debug("Resume pending continuation for client: %s", new Object[]{this.getClientId()});
                this.continuation.resume();
            }
            this.continuation = null;
        }
    }

    public boolean isLocal() {
        return true;
    }

    @Override
    public void remove(boolean timeout) {
        super.remove(timeout);
        this.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliver(AbstractChannel from, Message message, String subscriptionId) {
        message.setHeader("DSDstClientId", (Object)subscriptionId);
        ContinuationChannel continuationChannel = this;
        synchronized (continuationChannel) {
            this.messageQ.add(message);
            if (this.connected && this.responsesPending.get() < 1) {
                this.resume();
            }
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages() {
        ContinuationChannel continuationChannel = this;
        synchronized (continuationChannel) {
            return this.messageQ.size() > 0;
        }
    }

    public int responded() {
        return this.responsesPending.getAndDecrement();
    }

    public int responsePending() {
        return this.responsesPending.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<Message> takeMessages() {
        log.debug("Try to take %d messages", new Object[]{this.messageQ.size()});
        ContinuationChannel continuationChannel = this;
        synchronized (continuationChannel) {
            block4: {
                if (this.messageQ.size() != 0) break block4;
                return null;
            }
            log.debug("Take %d messages", new Object[]{this.messageQ.size()});
            Queue<Message> messages = this.messageQ;
            this.messageQ = new LinkedList<Message>();
            return messages;
        }
    }

    @Override
    protected void clearQueue() {
        this.messageQ.clear();
    }
}

