/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.AMFContextImpl;
import org.granite.context.GraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.Gravity;
import org.granite.gravity.tomcat.EventUtil;
import org.granite.gravity.tomcat.OutgoingPool;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.AMF3Serializer;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.UUIDUtil;

public class TomcatChannel
extends AbstractChannel
implements Runnable {
    private static final Logger log = Logger.getLogger(TomcatChannel.class);
    public static final String CHANNEL_ID_KEY = String.valueOf(TomcatChannel.class.getName()) + ".CHANNEL_ID";
    public static final String AMF3_MESSAGE_KEY = String.valueOf(TomcatChannel.class.getName()) + ".AMF3_MESSAGE_ID";
    private final OutgoingPool outgoing;
    private final ArrayList<Message> queue = new ArrayList();
    private final Lock stateLock = new ReentrantLock();
    private final Lock eventLock = new ReentrantLock();
    private State state = State.IDLE;
    private CometEvent event = null;

    public TomcatChannel(Gravity gravity, OutgoingPool outgoing) {
        super(gravity);
        this.outgoing = outgoing;
    }

    public Gravity getGravity() {
        return this.gravity;
    }

    public boolean setCometEvent(CometEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Channel: %s got new event: %s", new Object[]{this.getClientId(), EventUtil.toString(event)});
        }
        this.eventLock.lock();
        this.event = event;
        this.eventLock.unlock();
        return this.tryToDeliver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean timeout) {
        super.remove(timeout);
        this.outgoing.remove(this);
        this.eventLock.lock();
        if (this.event != null) {
            try {
                this.event.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.eventLock.unlock();
        ArrayList<Message> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.clear();
            this.queue.trimToSize();
        }
        this.stateLock.lock();
        this.state = State.IDLE;
        this.stateLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearQueue() {
        ArrayList<Message> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(AbstractChannel from, Message message, String subscriptionId) {
        log.debug("Channel: %s got new message: %s", new Object[]{this.getClientId(), message});
        message.setHeader("DSDstClientId", (Object)subscriptionId);
        ArrayList<Message> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.add(message);
        }
        this.tryToDeliver();
    }

    /*
     * Exception decompiling
     */
    protected boolean tryToDeliver() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block36: {
            this.stateLock.lock();
            try {
                if (this.state != State.QUEUED) {
                    this.state = State.IDLE;
                    return;
                }
                this.state = State.SENDING;
            }
            finally {
                this.stateLock.unlock();
            }
            this.eventLock.lock();
            pendingMessages = null;
            if (this.event != null) break block36;
            TomcatChannel.log.debug("Null event while running channel: %s", new Object[]{this.getClientId()});
lbl17:
            // 5 sources

            while (true) {
                GraniteContext.release();
                if (EventUtil.isValid(this.event)) {
                    try {
                        this.event.close();
                    }
                    catch (Exception e) {
                        TomcatChannel.log.error((Throwable)e, "Error while closing event: %s", new Object[]{this.event});
                    }
                }
                this.event = null;
                this.eventLock.unlock();
                this.stateLock.lock();
                this.state = State.IDLE;
                this.stateLock.unlock();
                return;
            }
        }
        try {
            try {
                block39: {
                    block38: {
                        request = null;
                        response = null;
                        try {
                            request = this.event.getHttpServletRequest();
                            response = this.event.getHttpServletResponse();
                        }
                        catch (Exception e) {
                            TomcatChannel.log.debug("Illegal event: %s", new Object[]{EventUtil.toString(this.event)});
                            ** GOTO lbl17
                        }
                        if (request != null && response != null) break block38;
                        TomcatChannel.log.debug("Illegal event (request or response is null): %s", new Object[]{EventUtil.toString(this.event)});
                        ** GOTO lbl17
                    }
                    requestMessage = (Message)request.getAttribute(TomcatChannel.AMF3_MESSAGE_KEY);
                    if (requestMessage != null) break block39;
                    TomcatChannel.log.debug("No request message while running channel: %s", new Object[]{this.getClientId()});
                    ** GOTO lbl17
                }
                var5_13 = this.queue;
                synchronized (var5_13) {
                    if (this.queue.isEmpty()) {
                        TomcatChannel.log.debug("Empty queue while running channel: %s", new Object[]{this.getClientId()});
                        // MONITOREXIT @DISABLED, blocks:[32, 4, 5, 7, 13] lbl53 : MonitorExitStatement: MONITOREXIT : var5_13
                        ** continue;
                    }
                    pendingMessages = this.queue.toArray(new AsyncMessage[this.queue.size()]);
                    this.queue.clear();
                    if (pendingMessages.length > 1024) {
                        this.queue.trimToSize();
                    }
                }
                responseMessages = new AsyncMessage[pendingMessages.length];
                i = 0;
                var10_15 = pendingMessages;
                var9_16 = pendingMessages.length;
                var8_18 = 0;
                while (var8_18 < var9_16) {
                    pendingMessage = var10_15[var8_18];
                    responseMessage = new AsyncMessage();
                    responseMessage.setBody(pendingMessage.getBody());
                    responseMessage.setClientId(pendingMessage.getClientId());
                    responseMessage.setCorrelationId(requestMessage.getMessageId());
                    responseMessage.setDestination(pendingMessage.getDestination());
                    responseMessage.setHeaders(pendingMessage.getHeaders());
                    responseMessage.setMessageId(UUIDUtil.randomUUID());
                    responseMessage.setTimestamp(System.currentTimeMillis());
                    responseMessages[i++] = responseMessage;
                    ++var8_18;
                }
                if (TomcatChannel.log.isDebugEnabled()) {
                    TomcatChannel.log.debug("Thread #%d - Sending: ", new Object[]{Thread.currentThread().getId(), responseMessages});
                }
                context = HttpGraniteContext.createThreadIntance((GraniteConfig)this.gravity.getGraniteConfig(), (ServicesConfig)this.gravity.getServicesConfig(), null, (HttpServletRequest)this.event.getHttpServletRequest(), (HttpServletResponse)response);
                ((AMFContextImpl)context.getAMFContext()).setCurrentAmf3Message(requestMessage);
                response.flushBuffer();
                response.setStatus(200);
                response.setContentType("application/x-amf");
                response.setDateHeader("Expire", 0L);
                response.setHeader("Cache-Control", "no-store");
                os = response.getOutputStream();
                serializer = new AMF3Serializer((OutputStream)os);
                serializer.writeObject((Object)responseMessages);
                response.flushBuffer();
                os.close();
            }
            catch (Exception e) {
                TomcatChannel.log.error((Throwable)e, "Error when sending response for channel: %s (retrying later)", new Object[]{this.getClientId()});
                var3_10 = this.queue;
                synchronized (var3_10) {
                    this.queue.addAll(0, (Collection<Message>)Arrays.asList(pendingMessages));
                }
                GraniteContext.release();
                if (EventUtil.isValid(this.event)) {
                    try {
                        this.event.close();
                    }
                    catch (Exception e) {
                        TomcatChannel.log.error((Throwable)e, "Error while closing event: %s", new Object[]{this.event});
                    }
                }
                this.event = null;
                this.eventLock.unlock();
                this.stateLock.lock();
                this.state = State.IDLE;
                this.stateLock.unlock();
            }
        }
        catch (Throwable var12_22) {
            GraniteContext.release();
            if (EventUtil.isValid(this.event)) {
                try {
                    this.event.close();
                }
                catch (Exception e) {
                    TomcatChannel.log.error((Throwable)e, "Error while closing event: %s", new Object[]{this.event});
                }
            }
            this.event = null;
            this.eventLock.unlock();
            this.stateLock.lock();
            this.state = State.IDLE;
            this.stateLock.unlock();
            throw var12_22;
        }
        GraniteContext.release();
        if (EventUtil.isValid(this.event)) {
            try {
                this.event.close();
            }
            catch (Exception e) {
                TomcatChannel.log.error((Throwable)e, "Error while closing event: %s", new Object[]{this.event});
            }
        }
        this.event = null;
        this.eventLock.unlock();
        this.stateLock.lock();
        this.state = State.IDLE;
        this.stateLock.unlock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IDLE,
        QUEUED,
        CANCELED,
        SENDING;

    }
}

