/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import flex.messaging.messages.Message;
import java.util.Arrays;
import java.util.TimerTask;
import org.granite.gravity.Gravity;
import org.granite.gravity.Subscriber;
import org.granite.gravity.util.ArrayUtil;

public abstract class AbstractChannel {
    private long accessed;
    private transient TimerTask timeoutTask;
    private final String clientId;
    protected final Gravity gravity;
    protected boolean connected = false;
    private Subscriber[] subscriptions = new Subscriber[0];

    protected AbstractChannel(Gravity gravity) {
        this.gravity = gravity;
        this.clientId = gravity.registerChannel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        AbstractChannel abstractChannel = this;
        synchronized (abstractChannel) {
            this.connected = true;
            return this.connected;
        }
    }

    public abstract void deliver(AbstractChannel var1, Message var2, String var3);

    public String getClientId() {
        return this.clientId;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " {clientId=" + this.clientId + ", connected=" + this.connected + ", subscriptions=" + Arrays.toString(this.subscriptions) + "}";
    }

    public void remove(boolean timeout) {
        if (!timeout) {
            this.timeoutTask.cancel();
            this.timeoutTask = null;
        }
        this.gravity.removeChannel(this.getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() {
        AbstractChannel abstractChannel = this;
        synchronized (abstractChannel) {
            this.accessed = System.currentTimeMillis();
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel();
            }
            this.timeoutTask = new TimerTask(){

                public void run() {
                    long now = System.currentTimeMillis();
                    if (AbstractChannel.this.accessed + AbstractChannel.this.gravity.getClientTimeoutMs() <= now) {
                        AbstractChannel.this.remove(true);
                    }
                }
            };
            this.gravity.scheduleChannelTimeout(this.timeoutTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(Subscriber subscription) {
        AbstractChannel abstractChannel = this;
        synchronized (abstractChannel) {
            this.subscriptions = (Subscriber[])ArrayUtil.addToArray(this.subscriptions, subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(Subscriber subscription) {
        AbstractChannel abstractChannel = this;
        synchronized (abstractChannel) {
            this.subscriptions = (Subscriber[])ArrayUtil.removeFromArray(this.subscriptions, subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribeAll() {
        Subscriber[] subscriptions;
        AbstractChannel abstractChannel = this;
        synchronized (abstractChannel) {
            this.clearQueue();
            subscriptions = this.subscriptions;
            this.subscriptions = new Subscriber[0];
        }
        Subscriber[] subscriberArray = subscriptions;
        int n = subscriptions.length;
        int n2 = 0;
        while (n2 < n) {
            Subscriber subscriber = subscriberArray[n2];
            subscriber.getTopic().unsubscribe(subscriber.getClient(), subscriber.getSubscriptionId());
            ++n2;
        }
    }

    protected abstract void clearQueue();

    public boolean equals(Object obj) {
        return obj instanceof AbstractChannel && ((AbstractChannel)obj).clientId.equals(this.clientId);
    }

    public int hashCode() {
        return this.clientId.hashCode();
    }
}

