/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.granite.config.GraniteConfig;
import org.granite.config.GraniteConfigListener;
import org.granite.config.ShutdownListener;
import org.granite.config.flex.ServicesConfig;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.Gravity;

public class GravityConfig {
    public static Gravity startGravity(ServletContext context, ChannelFactory channelFactory) throws ServletException {
        String reconnectMaxAttemps;
        String reconnectIntervalMs;
        Gravity gravity = null;
        String gravityJndiName = context.getInitParameter("gravityJndiName");
        if (gravityJndiName != null) {
            try {
                InitialContext ic = new InitialContext();
                gravity = (Gravity)ic.lookup(gravityJndiName);
            }
            catch (NamingException e) {
                throw new ServletException("Could not find Gravity service " + gravityJndiName, (Throwable)e);
            }
        }
        ServicesConfig servicesConfig = ServicesConfig.loadConfig((ServletContext)context);
        GraniteConfig graniteConfig = GraniteConfig.loadConfig((ServletContext)context);
        gravity = new Gravity(channelFactory, servicesConfig, graniteConfig);
        String clientTimeoutMs = context.getInitParameter("clientTimeoutMs");
        if (clientTimeoutMs != null) {
            gravity.setClientTimeoutMs(Long.parseLong(clientTimeoutMs));
        }
        if ((reconnectIntervalMs = context.getInitParameter("reconnectIntervalMs")) != null) {
            gravity.setReconnectIntervalMs(Long.parseLong(reconnectIntervalMs));
        }
        if ((reconnectMaxAttemps = context.getInitParameter("reconnectMaxAttemps")) != null) {
            gravity.setReconnectMaxAttempts(Long.parseLong(reconnectMaxAttemps));
        }
        try {
            gravity.start();
            context.setAttribute("org.granite.gravity.Gravity", (Object)gravity);
            GraniteConfigListener.registerShutdownListener((ServletContext)context, (ShutdownListener)gravity);
        }
        catch (Exception e) {
            throw new ServletException("Gravity initialization error", (Throwable)e);
        }
        return gravity;
    }
}

