/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.granite.gravity.tomcat.CometIO;
import org.granite.gravity.tomcat.EventUtil;
import org.granite.logging.Logger;

public abstract class AbstractCometProcessor
extends HttpServlet
implements CometProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AbstractCometProcessor.class);
    private static final String REQUEST_READER_KEY = String.valueOf(AbstractCometProcessor.class.getName()) + ".REQUEST_READER";
    private ServletConfig config = null;
    private boolean asynchronousRead = false;
    private int timeout = 0;

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        String timeout = config.getInitParameter("timeout");
        if (timeout != null) {
            try {
                this.timeout = Integer.parseInt(timeout);
            }
            catch (NumberFormatException e) {
                throw new ServletException("Illegal timeout value: " + timeout);
            }
            if (this.timeout < 0) {
                throw new ServletException("Illegal timeout value: " + timeout);
            }
            log.info("Using event timeout: %s", new Object[]{timeout});
        }
        this.asynchronousRead = "true".equalsIgnoreCase(config.getInitParameter("asynchronousRead"));
    }

    protected ServletConfig getConfig() {
        return this.config;
    }

    protected boolean isAsynchronousRead() {
        return this.asynchronousRead;
    }

    protected void setAsynchronousRead(boolean asynchronousRead) {
        this.asynchronousRead = asynchronousRead;
    }

    protected void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    public void destroy() {
        this.config = null;
    }

    public abstract CometIO createCometIO();

    public abstract boolean handleRequest(CometEvent var1, InputStream var2) throws IOException, ServletException;

    public abstract boolean handleEnd(CometEvent var1) throws IOException, ServletException;

    public abstract boolean handleError(CometEvent var1) throws IOException, ServletException;

    public void event(CometEvent event) throws IOException, ServletException {
        if (!EventUtil.isValid(event)) {
            log.error("Tomcat sent an invalid CometEvent: %s.%s", new Object[]{event.getEventType(), event.getEventSubType()});
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("%s.%s: %s/%s", new Object[]{event.getEventType(), event.getEventSubType(), event.getHttpServletRequest(), event.getHttpServletResponse()});
        }
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            this.begin(event);
        } else if (event.getEventType() == CometEvent.EventType.READ) {
            this.read(event);
        } else if (event.getEventType() == CometEvent.EventType.END) {
            this.end(event);
        } else if (event.getEventType() == CometEvent.EventType.ERROR) {
            this.error(event);
        } else {
            throw new ServletException("Unknown CometEvent type: " + event.getEventType());
        }
    }

    protected void begin(CometEvent event) throws IOException, ServletException {
        if (this.timeout > 0) {
            event.setTimeout(this.timeout);
        }
        HttpServletRequest request = event.getHttpServletRequest();
        CometIO io = this.createCometIO();
        request.setAttribute(REQUEST_READER_KEY, (Object)io);
        io.readFully((InputStream)request.getInputStream());
        if (this.handleRequest(event, io.getInputStream())) {
            try {
                event.close();
            }
            catch (Exception e) {
                log.error("Could not close event: %s", new Object[]{EventUtil.toString(event)});
            }
        }
    }

    protected void read(CometEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        CometIO io = (CometIO)request.getAttribute(REQUEST_READER_KEY);
        if (!io.readAvailable((InputStream)request.getInputStream()) && this.handleRequest(event, io.getInputStream())) {
            try {
                event.close();
            }
            catch (Exception e) {
                log.error("Could not close event: %s", new Object[]{EventUtil.toString(event)});
            }
        }
    }

    protected void end(CometEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        request.removeAttribute(REQUEST_READER_KEY);
        if (this.handleEnd(event)) {
            try {
                event.close();
            }
            catch (Exception e) {
                log.error("Could not close event: %s", new Object[]{EventUtil.toString(event)});
            }
        }
    }

    protected void error(CometEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        request.removeAttribute(REQUEST_READER_KEY);
        if (this.handleError(event)) {
            try {
                event.close();
            }
            catch (Exception e) {
                log.error("Could not close event: %s", new Object[]{EventUtil.toString(event)});
            }
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        throw new ServletException("Not in a valid Comet configuration (use an APR or NIO connector)");
    }
}

