/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.CometEvent;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.tomcat.AbstractCometProcessor;
import org.granite.gravity.tomcat.ByteArrayCometIO;
import org.granite.gravity.tomcat.CometIO;
import org.granite.gravity.tomcat.EventUtil;
import org.granite.gravity.tomcat.TomcatChannel;
import org.granite.gravity.tomcat.TomcatChannelFactory;
import org.granite.logging.Logger;

public class GravityTomcatServlet
extends AbstractCometProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GravityTomcatServlet.class);
    private Gravity gravity = null;
    private ServletConfig config = null;

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.gravity = GravityConfig.startGravity(config.getServletContext(), new TomcatChannelFactory(config));
        super.init(config);
    }

    public CometIO createCometIO() {
        return new ByteArrayCometIO();
    }

    /*
     * Exception decompiling
     */
    public boolean handleRequest(CometEvent event, InputStream content) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean handleEnd(CometEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        request.removeAttribute(TomcatChannel.AMF3_MESSAGE_KEY);
        request.removeAttribute(TomcatChannel.CHANNEL_ID_KEY);
        return true;
    }

    public boolean handleError(CometEvent event) throws IOException {
        HttpServletRequest request = event.getHttpServletRequest();
        try {
            String channelId = (String)request.getAttribute(TomcatChannel.CHANNEL_ID_KEY);
            TomcatChannel channel = (TomcatChannel)this.gravity.getChannel(channelId);
            if (channel != null && EventUtil.isTimeout(event)) {
                return channel.setCometEvent(event);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error while processing ERROR event: %s", new Object[]{EventUtil.toString(event)});
        }
        request.removeAttribute(TomcatChannel.AMF3_MESSAGE_KEY);
        request.removeAttribute(TomcatChannel.CHANNEL_ID_KEY);
        return true;
    }

    public void destroy() {
        super.destroy();
        this.gravity = null;
    }
}

