/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.granite.logging.Logger;

public class OutgoingPool {
    private static final Logger log = Logger.getLogger(OutgoingPool.class);
    public static final int DEFAULT_CORE_POOL_SIZE = 5;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = 20;
    public static final long DEFAULT_KEEP_ALIVE_TIME = 10000L;
    public static final int DEFAULT_QUEUE_CAPACITY = Integer.MAX_VALUE;
    private final BlockingQueue<Runnable> queue;
    private final ExecutorService threadPool;

    public OutgoingPool(int corePoolSize, int maximumPoolSize, long keepAliveTimeMillis, int queueCapacity) {
        log.info("Starting Gravity Tomcat Outgoing Pool (corePoolSize=%d, maximumPoolSize=%d, keepAliveTimeMillis=%d, queueCapacity=%d)...", new Object[]{corePoolSize, maximumPoolSize, keepAliveTimeMillis, queueCapacity});
        this.queue = new LinkedBlockingQueue<Runnable>(queueCapacity);
        this.threadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTimeMillis, TimeUnit.MILLISECONDS, this.queue);
    }

    public void deliver(Runnable channel) {
        this.threadPool.execute(channel);
    }

    public boolean remove(Runnable channel) {
        return this.queue.remove(channel);
    }

    public void stop() {
        log.info("Stopping Gravity Tomcat Outgoing Pool...", new Object[0]);
        this.threadPool.shutdownNow();
    }
}

