/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import javax.servlet.ServletConfig;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.Gravity;
import org.granite.gravity.tomcat.OutgoingPool;
import org.granite.gravity.tomcat.TomcatChannel;
import org.granite.logging.Logger;

public class TomcatChannelFactory
implements ChannelFactory {
    private static final Logger log = Logger.getLogger(TomcatChannelFactory.class);
    private static final String CORE_POOL_SIZE_KEY = "OutgoingPool.corePoolSize";
    private static final String MAXIMUM_POOL_SIZE_KEY = "OutgoingPool.maximumPoolSize";
    private static final String KEEP_ALIVE_TIME_KEY = "OutgoingPool.keepAliveTimeMillis";
    private static final String QUEUE_CAPACITY_KEY = "OutgoingPool.queueCapacity";
    private final OutgoingPool outgoingPool;

    public TomcatChannelFactory(ServletConfig config) {
        String sCorePoolSize = config.getInitParameter(CORE_POOL_SIZE_KEY);
        String sMaximumPoolSize = config.getInitParameter(MAXIMUM_POOL_SIZE_KEY);
        String sKeepAliveTimeMillis = config.getInitParameter(KEEP_ALIVE_TIME_KEY);
        String sQueueCapacity = config.getInitParameter(QUEUE_CAPACITY_KEY);
        int corePoolSize = 5;
        if (sCorePoolSize != null) {
            try {
                corePoolSize = Integer.parseInt(sCorePoolSize);
            }
            catch (NumberFormatException e) {
                log.warn((Throwable)e, "Illegal value for %s: %s", new Object[]{CORE_POOL_SIZE_KEY, sCorePoolSize});
            }
        }
        int maximumPoolSize = 20;
        if (sMaximumPoolSize != null) {
            try {
                maximumPoolSize = Integer.parseInt(sMaximumPoolSize);
            }
            catch (NumberFormatException e) {
                log.warn((Throwable)e, "Illegal value for %s: %s", new Object[]{MAXIMUM_POOL_SIZE_KEY, sMaximumPoolSize});
            }
        }
        long keepAliveTimeMillis = 10000L;
        if (sKeepAliveTimeMillis != null) {
            try {
                keepAliveTimeMillis = Long.parseLong(sKeepAliveTimeMillis);
            }
            catch (NumberFormatException e) {
                log.warn((Throwable)e, "Illegal value for %s: %s", new Object[]{KEEP_ALIVE_TIME_KEY, sKeepAliveTimeMillis});
            }
        }
        int queueCapacity = Integer.MAX_VALUE;
        if (sQueueCapacity != null) {
            try {
                queueCapacity = Integer.parseInt(sQueueCapacity);
            }
            catch (NumberFormatException e) {
                log.warn((Throwable)e, "Illegal value for %s: %s", new Object[]{QUEUE_CAPACITY_KEY, sQueueCapacity});
            }
        }
        this.outgoingPool = new OutgoingPool(corePoolSize, maximumPoolSize, keepAliveTimeMillis, queueCapacity);
    }

    public AbstractChannel newRemoteChannel(Gravity gravity) {
        return new TomcatChannel(gravity, this.outgoingPool);
    }

    public void stop() {
        this.outgoingPool.stop();
    }
}

