/*
 * Decompiled with CFR 0.152.
 */
package org.granite.guice;

import com.google.inject.Injector;
import flex.messaging.messages.RemotingMessage;
import javax.servlet.ServletContext;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.guice.GuiceServiceInvoker;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.service.SimpleServiceFactory;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceServiceFactory
extends SimpleServiceFactory {
    private Injector injector = null;

    public void configure(XMap properties) throws ServiceException {
        super.configure(properties);
        GraniteContext context = GraniteContext.getCurrentInstance();
        ServletContext sc = ((HttpGraniteContext)context).getServletContext();
        this.injector = (Injector)sc.getAttribute(Injector.class.getName());
    }

    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        GraniteContext context = GraniteContext.getCurrentInstance();
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        if (destination == null) {
            throw new ServiceException("No matching destination: " + destinationId);
        }
        String className = destination.getProperties().get("source");
        try {
            Class<?> gclass = Class.forName(className, true, ((Object)((Object)this)).getClass().getClassLoader());
            Object gobject = this.injector.getInstance(gclass);
            return new GuiceServiceInvoker(destination, this, gobject);
        }
        catch (Exception e) {
            throw new ServiceException("Class not found in classloader: " + className, (Throwable)e);
        }
    }

    public String toString() {
        return this.toString("\n  Guice Injector: " + this.injector);
    }
}

