/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.tide.annotations.BypassTideInterceptor;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.seam.TideInterceptor;
import org.granite.tide.seam.async.TideAsynchronousInterceptor;
import org.jboss.seam.Component;
import org.jboss.seam.Namespace;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.async.AsynchronousInterceptor;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.intercept.Interceptor;
import org.jboss.seam.log.Log;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.granite.tide.seam.init")
@Install(precedence=10)
@Startup
@BypassInterceptors
public class TideInit {
    @Logger
    private Log log;
    private Map<Component, Set<FactoryVariable>> factoryComponents = new HashMap<Component, Set<FactoryVariable>>();

    public TideInit() {
        if (!"conversationId".equals(Manager.instance().getConversationIdParameter())) {
            throw new RuntimeException("conversation-id-parameter must be set to the default value 'conversationId' in components.xml/core:manager");
        }
        Context context = Contexts.getApplicationContext();
        String[] stringArray = context.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component;
            Object object;
            String name = stringArray[n2];
            if (name.endsWith(".component") && (object = context.get(name)) instanceof Component && (component = (Component)object).isInterceptionEnabled() && component.getScope() != ScopeType.APPLICATION) {
                this.instrumentComponent(component);
            }
            ++n2;
        }
        Init.instance().importNamespace("org.granite.tide");
        this.scanFactoryComponents();
    }

    public static Set<FactoryVariable> getFactoredVariables(Component component) {
        TideInit init = (TideInit)Contexts.getApplicationContext().get(TideInit.class);
        return init.factoryComponents.get(component);
    }

    private void scanFactoryComponents() {
        try {
            String componentName;
            String expressionString;
            Init init = Init.instance();
            Field field = init.getClass().getDeclaredField("factories");
            field.setAccessible(true);
            Map factories = (Map)field.get(init);
            for (Map.Entry factory : factories.entrySet()) {
                String componentName2 = ((Init.FactoryMethod)factory.getValue()).getComponent().getName();
                this.addFactoryVariable(componentName2, (String)factory.getKey(), ((Init.FactoryMethod)factory.getValue()).getScope());
            }
            field = init.getClass().getDeclaredField("factoryMethodExpressions");
            field.setAccessible(true);
            Map factoryExpressions = (Map)field.get(init);
            for (Map.Entry factoryExpression : factoryExpressions.entrySet()) {
                expressionString = ((Init.FactoryExpression)factoryExpression.getValue()).getMethodBinding().getExpressionString();
                componentName = expressionString.substring(0, expressionString.indexOf(46));
                this.addFactoryVariable(componentName, (String)factoryExpression.getKey(), ((Init.FactoryExpression)factoryExpression.getValue()).getScope());
            }
            field = init.getClass().getDeclaredField("factoryValueExpressions");
            field.setAccessible(true);
            factoryExpressions = (Map)field.get(init);
            for (Map.Entry factoryExpression : factoryExpressions.entrySet()) {
                expressionString = ((Init.FactoryExpression)factoryExpression.getValue()).getMethodBinding().getExpressionString();
                componentName = expressionString.substring(0, expressionString.indexOf(46));
                this.addFactoryVariable(componentName, (String)factoryExpression.getKey(), ((Init.FactoryExpression)factoryExpression.getValue()).getScope());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Could not initialize factory components map correctly", (Throwable)e, new Object[0]);
        }
    }

    private void addFactoryVariable(String componentName, String variableName, ScopeType scope) {
        Component component = TideInit.lookupComponent(componentName);
        Set<FactoryVariable> variables = this.factoryComponents.get(component);
        if (variables == null) {
            variables = new HashSet<FactoryVariable>();
            this.factoryComponents.put(component, variables);
        }
        variables.add(new FactoryVariable(variableName, scope));
    }

    static Component lookupComponent(String componentName) {
        String nsName;
        Method m2;
        Init init = Init.instance();
        Component component = Component.forName((String)componentName);
        if (component != null) {
            return component;
        }
        for (Namespace ns : init.getGlobalImports()) {
            try {
                m2 = ns.getClass().getDeclaredMethod("qualifyName", String.class);
                m2.setAccessible(true);
                nsName = (String)Reflections.invoke((Method)m2, (Object)ns, (Object[])new Object[]{componentName});
                if (!nsName.startsWith("org.granite.tide") || (component = Component.forName((String)nsName)) == null) continue;
                return component;
            }
            catch (Exception m2) {
                // empty catch block
            }
        }
        for (Namespace ns : init.getGlobalImports()) {
            try {
                m2 = ns.getClass().getDeclaredMethod("qualifyName", String.class);
                m2.setAccessible(true);
                nsName = (String)Reflections.invoke((Method)m2, (Object)ns, (Object[])new Object[]{componentName});
                component = Component.forName((String)nsName);
                if (component == null) continue;
                return component;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static Init.FactoryMethod lookupFactory(String componentName) {
        String nsName;
        Method m2;
        Init init = Init.instance();
        Init.FactoryMethod factoryMethod = init.getFactory(componentName);
        if (factoryMethod != null) {
            return factoryMethod;
        }
        for (Namespace ns : init.getGlobalImports()) {
            try {
                m2 = ns.getClass().getDeclaredMethod("qualifyName", String.class);
                m2.setAccessible(true);
                nsName = (String)Reflections.invoke((Method)m2, (Object)ns, (Object[])new Object[]{componentName});
                if (!nsName.startsWith("org.granite.tide") || (factoryMethod = init.getFactory(nsName)) == null) continue;
                return factoryMethod;
            }
            catch (Exception m2) {
                // empty catch block
            }
        }
        for (Namespace ns : init.getGlobalImports()) {
            try {
                m2 = ns.getClass().getDeclaredMethod("qualifyName", String.class);
                m2.setAccessible(true);
                nsName = (String)Reflections.invoke((Method)m2, (Object)ns, (Object[])new Object[]{componentName});
                factoryMethod = init.getFactory(nsName);
                if (factoryMethod == null) continue;
                return factoryMethod;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static Init.FactoryExpression lookupFactoryExpression(String componentName) {
        String nsName;
        Method m2;
        Init init = Init.instance();
        Init.FactoryExpression factoryExpression = init.getFactoryMethodExpression(componentName);
        if (factoryExpression != null) {
            return factoryExpression;
        }
        factoryExpression = init.getFactoryValueExpression(componentName);
        if (factoryExpression != null) {
            return factoryExpression;
        }
        for (Namespace ns : init.getGlobalImports()) {
            try {
                m2 = ns.getClass().getDeclaredMethod("qualifyName", String.class);
                m2.setAccessible(true);
                nsName = (String)Reflections.invoke((Method)m2, (Object)ns, (Object[])new Object[]{componentName});
                if (!nsName.startsWith("org.granite.tide")) continue;
                factoryExpression = init.getFactoryMethodExpression(nsName);
                if (factoryExpression != null) {
                    return factoryExpression;
                }
                factoryExpression = init.getFactoryValueExpression(nsName);
                if (factoryExpression == null) continue;
                return factoryExpression;
            }
            catch (Exception m2) {
                // empty catch block
            }
        }
        for (Namespace ns : init.getGlobalImports()) {
            try {
                m2 = ns.getClass().getDeclaredMethod("qualifyName", String.class);
                m2.setAccessible(true);
                nsName = (String)Reflections.invoke((Method)m2, (Object)ns, (Object[])new Object[]{componentName});
                factoryExpression = init.getFactoryMethodExpression(nsName);
                if (factoryExpression != null) {
                    return factoryExpression;
                }
                factoryExpression = init.getFactoryValueExpression(nsName);
                if (factoryExpression == null) continue;
                return factoryExpression;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void instrumentComponent(Component component) {
        AsyncPublisher asyncPublisher;
        if (component.getBeanClass().isAnnotationPresent(BypassTideInterceptor.class)) {
            return;
        }
        List li = component.getInterceptors(InterceptorType.ANY);
        boolean newSortServer = false;
        boolean newSortClient = false;
        boolean found = false;
        for (Interceptor i : li) {
            if (!i.getUserInterceptorClass().equals(TideInterceptor.class)) continue;
            found = true;
            break;
        }
        if (!found) {
            component.addInterceptor(new Interceptor((Object)new TideInterceptor(), component));
            newSortServer = true;
        }
        if ((asyncPublisher = (AsyncPublisher)Component.getInstance((String)"org.granite.tide.seam.async.publisher")) != null) {
            boolean async = false;
            li = component.getClientSideInterceptors();
            for (Interceptor in : li) {
                if (!in.getUserInterceptorClass().equals(AsynchronousInterceptor.class)) continue;
                async = true;
                break;
            }
            if (async) {
                component.addInterceptor(new Interceptor((Object)new TideAsynchronousInterceptor(), component));
                newSortClient = true;
            }
        }
        if (newSortServer || newSortClient) {
            try {
                Method m = component.getClass().getDeclaredMethod("newSort", List.class);
                m.setAccessible(true);
                if (newSortServer) {
                    m.invoke((Object)component, component.getInterceptors(InterceptorType.SERVER));
                }
                if (newSortClient) {
                    m.invoke((Object)component, component.getInterceptors(InterceptorType.CLIENT));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class FactoryVariable {
        private final String variableName;
        private final ScopeType scope;

        public FactoryVariable(String variableName, ScopeType scope) {
            this.variableName = variableName;
            this.scope = scope;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public ScopeType getScope() {
            return this.scope;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FactoryVariable)) {
                return false;
            }
            return ((FactoryVariable)obj).variableName.equals(this.variableName) && ((FactoryVariable)obj).scope.equals((Object)this.scope);
        }

        public int hashCode() {
            return (String.valueOf(this.variableName) + "@" + this.scope).hashCode();
        }
    }
}

