/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam.lazy;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.granite.tide.ITidePersistenceManager;
import org.granite.tide.data.DataMergeContext;
import org.granite.tide.seam.lazy.TidePersistenceFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.Log;

@Name(value="org.granite.tide.seam.seamInitializer")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
@BypassInterceptors
public class SeamInitializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Logger
    Log log;
    private ITidePersistenceManager pm = null;
    private Set<Object> loadedEntities = new HashSet<Object>();

    @Transactional
    public Object lazyInitialize(Object entity, String[] propertyNames) {
        boolean removeAfterCall = false;
        try {
            boolean find = true;
            if (entity instanceof String) {
                String expression = "${" + entity + "}";
                Expressions.ValueExpression valueExpr = Expressions.instance().createValueExpression(expression, Object.class);
                entity = valueExpr.getValue();
                find = false;
            }
            if (this.pm == null) {
                removeAfterCall = true;
                this.pm = this.tryToDetermineInitiailzer();
                if (this.pm == null) {
                    throw new RuntimeException("TideInitializer is null, Entities with Lazy relationships have to be retrieved in a conversation, or the EntityManager name must be entityManager");
                }
            }
            Object object = this.pm.attachEntity(entity, propertyNames, find, false);
            return object;
        }
        finally {
            if (removeAfterCall) {
                Component.forName((String)"org.granite.tide.seam.seamInitializer").destroy((Object)this);
            }
        }
    }

    protected ITidePersistenceManager tryToDetermineInitiailzer() {
        EntityManager em = this.findEntityManager();
        if (em != null) {
            return TidePersistenceFactory.createTidePersistence(null, em);
        }
        return null;
    }

    protected EntityManager findEntityManager() {
        return (EntityManager)Component.getInstance((String)"entityManager");
    }

    public static SeamInitializer instance() {
        return (SeamInitializer)Component.getInstance(SeamInitializer.class);
    }

    public void setTidePersistenceManager(ITidePersistenceManager pm) {
        this.pm = pm;
    }

    public ITidePersistenceManager getTidePersistenceManager() {
        return this.pm;
    }

    public void restoreLoadedEntities() {
        DataMergeContext.restoreLoadedEntities(this.loadedEntities);
    }

    public void saveLoadedEntities() {
        for (Object entity : DataMergeContext.getLoadedEntities()) {
            this.loadedEntities.add(entity);
        }
    }
}

