/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.granite.tide.TideMessage;
import org.granite.tide.TideStatusMessages;
import org.granite.tide.seam.AbstractSeamServiceContext;
import org.granite.tide.seam.TideMessages;
import org.granite.util.Reflections;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.faces.FacesMessages;

@Scope(value=ScopeType.SESSION)
@Name(value="org.granite.tide.seam.serviceContext")
@Install(precedence=10)
@BypassInterceptors
public class SeamServiceContext
extends AbstractSeamServiceContext {
    private static final long serialVersionUID = 1L;

    protected void initTideMessages() {
        FacesMessages.instance();
    }

    protected void clearTideMessages() {
        if (FacesMessages.instance() instanceof TideMessages) {
            ((TideMessages)FacesMessages.instance()).clearTideMessages();
        } else {
            try {
                Reflections.invoke((Method)FacesMessages.instance().getClass().getMethod("clear", new Class[0]), (Object)FacesMessages.instance(), (Object[])new Object[0]);
            }
            catch (Exception e) {
                this.log.error((Object)"Could not clear list of TideMessages", (Throwable)e, new Object[0]);
            }
        }
    }

    protected TideStatusMessages getTideMessages() {
        FacesMessages.afterPhase();
        FacesMessages.instance().beforeRenderResponse();
        List facesMessages = FacesMessages.instance().getCurrentMessages();
        ArrayList<TideMessage> tideMessages = new ArrayList<TideMessage>(facesMessages.size());
        for (FacesMessage fm : facesMessages) {
            String severity = null;
            if (fm.getSeverity() == FacesMessage.SEVERITY_INFO) {
                severity = "INFO";
            } else if (fm.getSeverity() == FacesMessage.SEVERITY_WARN) {
                severity = "WARNING";
            } else if (fm.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                severity = "ERROR";
            } else if (fm.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                severity = "FATAL";
            }
            tideMessages.add(new TideMessage(severity, fm.getSummary(), fm.getDetail()));
        }
        return new TideStatusMessages(tideMessages);
    }
}

