/*
 * Decompiled with CFR 0.152.
 */
package org.granite.seam;

import flex.messaging.messages.Message;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.HttpServletRequestParamWrapper;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.web.ServletContexts;

public class SeamInterceptor
implements AMF3MessageInterceptor {
    private static final Logger log = Logger.getLogger(SeamInterceptor.class);
    private static final String CONVERSATION_ID = "conversationId";
    private static final String PARENT_CONVERSATION_ID = "parentConversationId";
    private static final String IS_LONG_RUNNING_CONVERSATION = "isLongRunningConversation";
    private static final String WAS_LONG_RUNNING_CONVERSATION_CREATED = "wasLongRunningConversationCreated";
    private static final String WAS_LONG_RUNNING_CONVERSATION_ENDED = "wasLongRunningConversationEnded";
    private static final String MESSAGE_HEADER = "MESSAGE_HEADER";
    private static final String MSG_SEP = ":;:";

    public void before(Message amfReqMessage) {
        if (log.isTraceEnabled()) {
            log.trace("Pre processing of request message: %s", new Object[]{amfReqMessage});
        }
        try {
            GraniteContext context = GraniteContext.getCurrentInstance();
            if (context instanceof HttpGraniteContext) {
                log.debug("Creating custom HttpServletRequest wrapper", new Object[0]);
                HttpServletRequestParamWrapper request = new HttpServletRequestParamWrapper(((HttpGraniteContext)context).getRequest());
                this.initializeFacesContext((HttpServletRequest)request, (HttpGraniteContext)context);
                this.exportHeaders(request, amfReqMessage);
                this.initializeSeamContext((HttpServletRequest)request);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception while pre processing the request message.", new Object[0]);
            throw new ServiceException("Error while pre processing the request message - " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Message amfReqMessage, Message amfRespMessage) {
        block10: {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("Post processing of response message: %s", new Object[]{amfReqMessage});
                }
                if (!(GraniteContext.getCurrentInstance() instanceof HttpGraniteContext)) break block10;
                try {
                    this.importHeaders(amfRespMessage);
                }
                finally {
                    this.destroySeamContext();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception while post processing the response message.", new Object[0]);
                throw new ServiceException("Error while post processing the response message - " + e.getMessage());
            }
            finally {
                FacesContext context = FacesContext.getCurrentInstance();
                if (context != null) {
                    context.release();
                }
            }
        }
    }

    private void exportHeaders(HttpServletRequestParamWrapper request, Message amf3RequestMessage) {
        Map headerMap = amf3RequestMessage.getHeaders();
        if (headerMap != null && headerMap.size() > 0) {
            for (String key : headerMap.keySet()) {
                String value = headerMap.get(key) == null ? null : headerMap.get(key).toString();
                if (value == null) continue;
                request.setParameter(key, value);
            }
        }
    }

    private void importHeaders(Message amf3ResponseMessage) {
        if (amf3ResponseMessage != null) {
            Conversation conversation = Conversation.instance();
            if (Contexts.getEventContext().isSet("org.granite.tide.conversation.wasLongRunning") && !conversation.isLongRunning()) {
                amf3ResponseMessage.setHeader(WAS_LONG_RUNNING_CONVERSATION_ENDED, (Object)true);
            }
            if (Contexts.getEventContext().isSet("org.granite.tide.conversation.wasCreated") && conversation.isLongRunning()) {
                amf3ResponseMessage.setHeader(WAS_LONG_RUNNING_CONVERSATION_CREATED, (Object)true);
            }
            log.debug("CONVERSATION_ID: %s", new Object[]{conversation.getId()});
            amf3ResponseMessage.setHeader(CONVERSATION_ID, (Object)conversation.getId());
            log.debug("PARENT_CONVERSATION_ID: %s", new Object[]{conversation.getParentId()});
            amf3ResponseMessage.setHeader(PARENT_CONVERSATION_ID, (Object)conversation.getParentId());
            log.debug("IS_LONG_RUNNING_CONVERSATION: %s", new Object[]{conversation.isLongRunning()});
            amf3ResponseMessage.setHeader(IS_LONG_RUNNING_CONVERSATION, (Object)conversation.isLongRunning());
            log.debug("Processing the Faces messages.", new Object[0]);
            this.processFacesMessages(amf3ResponseMessage);
        }
    }

    private void processFacesMessages(Message amf3ResponseMessage) {
        if (amf3ResponseMessage != null) {
            FacesMessages.afterPhase();
            FacesMessages.instance().beforeRenderResponse();
            Iterator messageItr = FacesContext.getCurrentInstance().getMessages();
            log.debug("Found Messages: %b", new Object[]{messageItr.hasNext()});
            StringBuilder messagesBuf = new StringBuilder();
            while (messageItr.hasNext()) {
                FacesMessage msg = (FacesMessage)messageItr.next();
                log.debug("FacesMessages %s - %s", new Object[]{msg.getDetail(), msg.getSummary()});
                messagesBuf.append(msg.getSummary());
                messagesBuf.append(MSG_SEP);
            }
            String messageStr = messagesBuf.toString().trim();
            if (messageStr.length() > 0) {
                messageStr = messageStr.substring(0, messageStr.lastIndexOf(MSG_SEP));
                amf3ResponseMessage.setHeader(MESSAGE_HEADER, (Object)messageStr);
            }
        }
    }

    private void initializeSeamContext(HttpServletRequest request) {
        log.debug("beginning request", new Object[0]);
        ServletLifecycle.beginRequest((HttpServletRequest)request);
        ServletContexts.instance().setRequest(request);
        Manager.instance().setConversationIdParameter(CONVERSATION_ID);
        this.restoreConversationId();
        String conversationId = ConversationPropagation.instance().getConversationId();
        Manager.instance().restoreConversation();
        ServletLifecycle.resumeConversation((HttpServletRequest)request);
        this.handleConversationPropagation();
        if (conversationId != null && !conversationId.equals(Manager.instance().getCurrentConversationId())) {
            Manager.instance().updateCurrentConversationId(conversationId);
        }
        if (Manager.instance().isLongRunningConversation()) {
            Contexts.getEventContext().set("org.granite.tide.conversation.wasLongRunning", (Object)true);
        }
        if (request.getSession(false) == null) {
            request.getSession(true);
        }
        if (Boolean.TRUE.toString().equals(request.getParameter("org.granite.tide.isFirstCall"))) {
            Contexts.getSessionContext().set("org.granite.tide.isFirstCall", (Object)Boolean.TRUE);
        }
        if (Boolean.TRUE.toString().equals(request.getParameter("org.granite.tide.isFirstConversationCall")) && Manager.instance().isLongRunningConversation()) {
            Contexts.getConversationContext().set("org.granite.tide.isFirstConversationCall", (Object)Boolean.TRUE);
        }
    }

    private void destroySeamContext() {
        if (Manager.instance().isLongRunningConversation()) {
            Conversation conversation = Conversation.instance();
            try {
                Method method = conversation.getClass().getDeclaredMethod("flush", new Class[0]);
                method.setAccessible(true);
                Reflections.invoke((Method)method, (Object)conversation, (Object[])new Object[0]);
            }
            catch (Exception e) {
                log.error("Could not flush current long-running conversation " + conversation.getId(), new Object[]{e});
            }
        }
        Manager.instance().endRequest((Map)new ServletRequestSessionMap(ServletContexts.getInstance().getRequest()));
        ServletLifecycle.endRequest((HttpServletRequest)ServletContexts.getInstance().getRequest());
        log.debug("ended request", new Object[0]);
    }

    private FacesContext initializeFacesContext(HttpServletRequest request, HttpGraniteContext context) throws ServletException {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext != null) {
                return facesContext;
            }
            FacesContextFactory contextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Lifecycle lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
            facesContext = contextFactory.getFacesContext((Object)context.getServletContext(), (Object)request, (Object)context.getResponse(), lifecycle);
            InnerFacesContext.setFacesContextAsCurrentInstance(facesContext);
            return facesContext;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void handleConversationPropagation() {
        Manager.instance().handleConversationPropagation(ServletContexts.getInstance().getRequest().getParameterMap());
    }

    protected void restoreConversationId() {
        ConversationPropagation.instance().restoreConversationId(ServletContexts.getInstance().getRequest().getParameterMap());
    }

    private static abstract class InnerFacesContext
    extends FacesContext {
        private InnerFacesContext() {
        }

        protected static void setFacesContextAsCurrentInstance(FacesContext facesContext) {
            FacesContext.setCurrentInstance((FacesContext)facesContext);
        }
    }
}

