/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam.async;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.Gravity;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.async.TideChannel;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.ServletLifecycle;

@Name(value="org.granite.tide.seam.async.publisher")
@Install(precedence=10, classDependencies={"org.granite.gravity.Gravity"})
@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@AutoCreate
public class SeamAsyncPublisher
implements AsyncPublisher {
    private static final long serialVersionUID = -5395975397632138270L;
    public static final String DESTINATION_NAME = "seamAsync";

    private Gravity getGravity() {
        return (Gravity)ServletLifecycle.getServletContext().getAttribute("org.granite.gravity.Gravity");
    }

    private TideChannel getChannel(String sessionId) {
        String channelId;
        TideChannel channel = null;
        Gravity gravity = this.getGravity();
        if (gravity != null && (channel = (TideChannel)gravity.getChannel(channelId = "tide.channel." + sessionId)) == null) {
            channel = new TideChannel(gravity);
            gravity.registerChannel((AbstractChannel)channel);
        }
        return channel;
    }

    public void initThread() {
        this.getGravity().initThread();
    }

    public void publishMessage(String sessionId, Object body) {
        TideChannel channel = this.getChannel(sessionId);
        if (channel != null) {
            AsyncMessage message = new AsyncMessage();
            message.setHeader("DSSubtopic", (Object)("tide.events." + sessionId));
            message.setClientId((Object)channel.getClientId());
            message.setDestination(DESTINATION_NAME);
            message.setBody(body);
            this.getGravity().publishMessage((AbstractChannel)channel, (Message)message);
        }
    }
}

