/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.servlet.http.HttpSession;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.ITidePersistenceManager;
import org.granite.tide.TideServiceContext;
import org.granite.tide.TideStatusMessages;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.invocation.ContextEvent;
import org.granite.tide.invocation.ContextResult;
import org.granite.tide.invocation.ContextUpdate;
import org.granite.tide.invocation.InvocationCall;
import org.granite.tide.invocation.InvocationResult;
import org.granite.tide.seam.ScopedContextResult;
import org.granite.tide.seam.TideDataModel;
import org.granite.tide.seam.TideInit;
import org.granite.tide.seam.TideInvocation;
import org.granite.tide.seam.TideUserEvents;
import org.granite.tide.seam.UserEvents;
import org.granite.tide.seam.async.AsyncContext;
import org.granite.tide.seam.lazy.SeamInitializer;
import org.granite.util.Reflections;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.framework.Home;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSeamServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    public static final String COMPONENT_NAME = "org.granite.tide.seam.serviceContext";
    @Logger
    protected Log log;
    private UserEvents userEvents;
    private boolean isAsynchronousContext = true;
    private static final String RESULTS_EVAL_ATTRIBUTE = String.valueOf(AbstractSeamServiceContext.class.getName()) + "_resultsEval";
    private static final String RESULTS_EVAL_UNSPECIFIED_ATTRIBUTE = String.valueOf(AbstractSeamServiceContext.class.getName()) + "_resultsEval_unspecified";
    private static final ScopeType[] EVAL_SCOPE_TYPES = new ScopeType[]{ScopeType.UNSPECIFIED, ScopeType.EVENT, ScopeType.CONVERSATION, ScopeType.SESSION, ScopeType.BUSINESS_PROCESS, ScopeType.APPLICATION};

    public void initCall() {
        super.initCall();
        if (this.userEvents != null) {
            return;
        }
        if (this.getSessionId() != null) {
            this.userEvents = TideUserEvents.instance().getUserEvents(this.getSessionId());
        } else {
            GraniteContext graniteContext = GraniteContext.getCurrentInstance();
            if (graniteContext instanceof HttpGraniteContext) {
                HttpSession session = ((HttpGraniteContext)graniteContext).getSession(false);
                if (session != null) {
                    this.setSessionId(session.getId());
                }
                this.isAsynchronousContext = false;
            }
        }
    }

    public void setSessionId(String sessionId) {
        super.setSessionId(sessionId);
        this.userEvents = TideUserEvents.instance().getUserEvents(sessionId);
    }

    @Destroy
    public void endSession() {
        if (!this.isAsynchronousContext && this.getSessionId() != null) {
            TideUserEvents.instance().unregisterSession(this.getSessionId());
        }
    }

    private Map<ContextResult, Boolean> getResultsEval(ScopeType scopeType) {
        Context context = Contexts.getEventContext();
        String att = RESULTS_EVAL_UNSPECIFIED_ATTRIBUTE;
        if (scopeType == ScopeType.STATELESS) {
            att = RESULTS_EVAL_ATTRIBUTE;
        } else if (scopeType != ScopeType.UNSPECIFIED) {
            context = scopeType.getContext();
            att = RESULTS_EVAL_ATTRIBUTE;
        }
        HashMap resultsEval = (HashMap)context.get(att);
        if (resultsEval == null) {
            resultsEval = new HashMap();
            context.set(att, resultsEval);
        }
        return resultsEval;
    }

    public AsyncContext getAsyncContext() {
        ArrayList<ContextResult> resultsEval = new ArrayList<ContextResult>();
        ScopeType[] scopeTypeArray = EVAL_SCOPE_TYPES;
        int n = EVAL_SCOPE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            ScopeType evalScopeType = scopeTypeArray[n2];
            resultsEval.addAll(this.getResultsEval(evalScopeType).keySet());
            ++n2;
        }
        return new AsyncContext(this.getSessionId(), resultsEval);
    }

    public void setAsyncContext(AsyncContext asyncContext) {
        AsyncPublisher asyncPublisher = this.getAsyncPublisher();
        if (asyncPublisher != null) {
            asyncPublisher.initThread();
        }
        Contexts.getSessionContext().set("org.jboss.seam.security.identity", (Object)asyncContext.getIdentity());
        this.setSessionId(asyncContext.getSessionId());
        for (ContextResult resultEval : asyncContext.getResults()) {
            if (resultEval instanceof ScopedContextResult) {
                this.getResultsEval(((ScopedContextResult)resultEval).getScope()).put(resultEval, Boolean.FALSE);
                continue;
            }
            this.getResultsEval(ScopeType.UNSPECIFIED).put(resultEval, Boolean.FALSE);
        }
    }

    protected abstract TideStatusMessages getTideMessages();

    protected abstract void initTideMessages();

    protected abstract void clearTideMessages();

    public Object findComponent(String componentName) {
        Component component = TideInit.lookupComponent(componentName);
        if (component == null) {
            return null;
        }
        return Component.getInstance((String)component.getName());
    }

    public Class<?> findComponentClass(String componentName) {
        Component component = TideInit.lookupComponent(componentName);
        if (component == null) {
            return null;
        }
        return component.getBeanClass();
    }

    @Observer(value={"org.jboss.seam.beginConversation"})
    public void observeBeginConversation() {
        Contexts.getEventContext().set("org.granite.tide.conversation.wasCreated", (Object)true);
    }

    public void raiseEvent(String type, Object ... params) {
        TideInvocation tideInvocation = TideInvocation.get();
        if (tideInvocation == null) {
            return;
        }
        if (this.userEvents != null) {
            String sessionId;
            if (!type.endsWith("org.jboss.seam.international.localeSelector")) {
                this.log.debug((Object)"Intercept event {0}", new Object[]{type});
            }
            if ((sessionId = this.getSessionId()) != null && this.userEvents.hasEventType(type)) {
                tideInvocation.addEvent(new ContextEvent(type, params));
            }
        } else if (Contexts.getSessionContext().isSet("org.granite.seam.login")) {
            tideInvocation.addEvent(new ContextEvent(type, params));
        }
    }

    protected AsyncPublisher getAsyncPublisher() {
        return (AsyncPublisher)Component.getInstance((String)"org.granite.tide.seam.async.publisher");
    }

    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName) {
        String sessionId;
        InvocationCall call = (InvocationCall)c;
        List listeners = call.getListeners();
        List updates = call.getUpdates();
        Object[] results = call.getResults();
        if (Contexts.isEventContextActive() && Contexts.isSessionContextActive() && (Contexts.getSessionContext().isSet("org.granite.tide.isFirstCall") || Contexts.getSessionContext().isSet("org.granite.seam.login"))) {
            for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval(ScopeType.SESSION).entrySet()) {
                if (me.getKey().getExpression() != null || !Contexts.getSessionContext().isSet(me.getKey().getComponentName())) continue;
                me.setValue(Boolean.TRUE);
            }
            Contexts.getSessionContext().remove("org.granite.seam.login");
            Contexts.getSessionContext().remove("org.granite.tide.isFirstCall");
            if (Identity.instance().isLoggedIn() && Contexts.isEventContextActive()) {
                Contexts.getEventContext().set("org.jboss.seam.security.silentLogin", (Object)true);
            }
        }
        if (Contexts.isEventContextActive() && Contexts.isConversationContextActive() && Contexts.getConversationContext().isSet("org.granite.tide.isFirstConversationCall")) {
            for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval(ScopeType.CONVERSATION).entrySet()) {
                if (me.getKey().getExpression() != null || !Contexts.getConversationContext().isSet(me.getKey().getComponentName())) continue;
                me.setValue(Boolean.TRUE);
            }
            Contexts.getConversationContext().remove("org.granite.tide.isFirstConversationCall");
        }
        if ((sessionId = this.getSessionId()) != null && listeners != null) {
            for (String listener : listeners) {
                TideUserEvents.instance().registerEventType(sessionId, listener);
            }
            if (this.userEvents == null) {
                this.userEvents = TideUserEvents.instance().getUserEvents(this.getSessionId());
            }
        }
        if (results != null) {
            Map<ContextResult, Boolean> resultsEval = this.getResultsEval(ScopeType.UNSPECIFIED);
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                ContextResult cr = (ContextResult)result;
                resultsEval.put(new ScopedContextResult(cr.getComponentName(), cr.getExpression(), ScopeType.UNSPECIFIED, null), Boolean.TRUE);
                ++n2;
            }
        }
        boolean instrumented = false;
        Component component = null;
        if (componentName != null) {
            component = TideInit.lookupComponent(componentName);
            if (component.isInterceptionEnabled()) {
                instrumented = true;
            }
            for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval(component.getScope()).entrySet()) {
                if (!me.getKey().getComponentName().equals(componentName)) continue;
                me.setValue(Boolean.TRUE);
            }
        }
        this.initTideMessages();
        SeamInitializer.instance().restoreLoadedEntities();
        TideInvocation tideInvocation = TideInvocation.init();
        tideInvocation.update(updates);
        if (!instrumented) {
            this.restoreContext(updates, component, null);
            tideInvocation.updated();
        }
    }

    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName) {
        TideInvocation tideInvocation = TideInvocation.get();
        List<ContextUpdate> results = null;
        boolean inConversation = false;
        boolean restrict = false;
        Component component = null;
        if (componentName != null) {
            component = TideInit.lookupComponent(componentName);
            if (Contexts.isMethodContextActive() && Contexts.getMethodContext().isSet(component.getName())) {
                inConversation = true;
            } else if (Contexts.isEventContextActive() && Contexts.getEventContext().isSet(component.getName())) {
                inConversation = true;
            } else if (Contexts.isPageContextActive() && Contexts.getPageContext().isSet(component.getName())) {
                inConversation = true;
            } else if (Contexts.isConversationContextActive() && Contexts.getConversationContext().isSet(component.getName())) {
                inConversation = true;
            }
            restrict = component.beanClassHasAnnotation(Restrict.class);
        }
        results = !tideInvocation.isEvaluated() ? this.evaluateResults(null, null, componentName == null && (context.getMethod() == null || !"resyncContext".equals(context.getMethod().getName()))) : tideInvocation.getResults();
        InvocationResult res = new InvocationResult(result, results);
        res.setInConversation(inConversation);
        res.setRestrict(restrict);
        res.setEvents(tideInvocation.getEvents());
        SeamInitializer.instance().saveLoadedEntities();
        TideStatusMessages statusMessages = this.getTideMessages();
        res.setMessages(statusMessages.getMessages());
        res.setKeyedMessages(statusMessages.getKeyedMessages());
        this.clearTideMessages();
        TideInvocation.remove();
        return res;
    }

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName) {
        this.clearTideMessages();
        TideInvocation.remove();
    }

    public void addResultEval(ScopedContextResult result) {
        this.getResultsEval(result.getScope()).put(result, Boolean.TRUE);
    }

    public void restoreContext(List<ContextUpdate> updates, Component component, Object target) {
        if (updates == null) {
            return;
        }
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        for (ContextUpdate update : updates) {
            boolean disabled;
            this.log.debug((Object)"Before invocation: evaluating expression #0.#1", new Object[]{update.getComponentName(), update.getExpression()});
            Component sourceComponent = TideInit.lookupComponent(update.getComponentName());
            String sourceComponentName = sourceComponent != null ? sourceComponent.getName() : update.getComponentName();
            Object previous = null;
            if (update.getExpression() != null) {
                if (target == null && (component == null || !component.getName().equals(sourceComponentName))) continue;
                String[] path = update.getExpression().split("\\.");
                Object instance = component != null && component.getName().equals(sourceComponentName) ? target : Component.getInstance((String)sourceComponentName);
                boolean bl = disabled = instance != null && sourceComponent != null && config.isComponentTideDisabled(sourceComponentName, sourceComponent.getBeanClass(), instance);
                if (disabled) continue;
                Object bean = instance;
                Object value = instance;
                List dmsFields = instance != null && path.length == 1 ? Reflections.getFields(instance.getClass(), DataModelSelection.class) : null;
                ArrayList<String> dmsFieldNames = null;
                if (dmsFields != null && !dmsFields.isEmpty()) {
                    dmsFieldNames = new ArrayList<String>(dmsFields.size());
                    for (Field f : dmsFields) {
                        dmsFieldNames.add(f.getName());
                    }
                }
                if (update.getValue() != null) {
                    org.granite.util.Entity entity;
                    boolean getPrevious = true;
                    if (update.getValue().getClass().getAnnotation(Entity.class) != null && (entity = new org.granite.util.Entity(update.getValue())).getIdentifier() == null) {
                        getPrevious = false;
                    }
                    if (getPrevious) {
                        try {
                            int i = 0;
                            while (i < path.length) {
                                if (value != null) {
                                    if (i == 0 && dmsFieldNames != null && dmsFieldNames.contains(path[0])) {
                                        Field field = Reflections.getField(value.getClass(), (String)path[i]);
                                        field.setAccessible(true);
                                        value = org.jboss.seam.util.Reflections.get((Field)field, (Object)value);
                                        if (i < path.length - 1) {
                                            bean = value;
                                        }
                                    } else {
                                        Method getter = Reflections.getGetterMethod(value.getClass(), (String)path[i]);
                                        value = org.jboss.seam.util.Reflections.invoke((Method)getter, (Object)value, (Object[])new Object[0]);
                                        if (i < path.length - 1) {
                                            bean = value;
                                        }
                                    }
                                    ++i;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.log.warn((Object)("Partial merge only: " + e.getMessage()), new Object[0]);
                            value = null;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not get property: " + update.toString(), e);
                        }
                        previous = value;
                    }
                }
                try {
                    if (bean != null && path.length == 1 && dmsFieldNames != null && dmsFieldNames.contains(path[0])) {
                        Field field = Reflections.getField(bean.getClass(), (String)path[0]);
                        field.setAccessible(true);
                        value = GraniteContext.getCurrentInstance().getGraniteConfig().getConverters().convert(update.getValue(), field.getType());
                        value = this.mergeExternal(value, previous);
                        org.jboss.seam.util.Reflections.set((Field)field, (Object)bean, (Object)value);
                        continue;
                    }
                    if (bean == null) continue;
                    Method setter = org.jboss.seam.util.Reflections.getSetterMethod(bean.getClass(), (String)path[path.length - 1]);
                    Type type = setter.getParameterTypes()[0];
                    if (bean instanceof Home && "id".equals(path[path.length - 1])) {
                        try {
                            Class entityClass = ((Home)bean).getEntityClass();
                            org.granite.util.Entity entity = new org.granite.util.Entity((Object)entityClass);
                            type = entity.getIdentifierType();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    value = GraniteContext.getCurrentInstance().getGraniteConfig().getConverters().convert(update.getValue(), type);
                    value = this.mergeExternal(value, previous);
                    org.jboss.seam.util.Reflections.invoke((Method)setter, (Object)bean, (Object[])new Object[]{value});
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not restore property: " + update.toString(), e);
                }
            }
            if (sourceComponent != null) {
                boolean disabled2;
                ScopeType scope = sourceComponent.getScope();
                if ((!update.getInConversation() || scope != ScopeType.EVENT && scope != ScopeType.STATELESS && scope != ScopeType.CONVERSATION && scope != ScopeType.BUSINESS_PROCESS && scope != ScopeType.METHOD && scope != ScopeType.PAGE) && (update.getInConversation() || scope != ScopeType.EVENT && scope != ScopeType.STATELESS && scope != ScopeType.SESSION && scope != ScopeType.METHOD && scope != ScopeType.PAGE)) {
                    scope = ScopeType.EVENT;
                }
                boolean bl = disabled2 = (previous = scope.getContext().get(sourceComponentName)) != null && config.isComponentTideDisabled(sourceComponentName, sourceComponent.getBeanClass(), previous);
                if (disabled2) continue;
                Object value = this.mergeExternal(update.getValue(), previous);
                scope.getContext().set(sourceComponentName, value);
                continue;
            }
            Object[] prev = AbstractSeamServiceContext.lookupInStatefulContexts(sourceComponentName, ScopeType.UNSPECIFIED);
            ScopeType scope = ScopeType.UNSPECIFIED;
            if (prev != null) {
                previous = prev[0];
                scope = (ScopeType)prev[1];
            }
            boolean bl = disabled = previous != null && config.isComponentTideDisabled(sourceComponentName, previous.getClass(), previous);
            if (disabled) continue;
            if (scope == ScopeType.UNSPECIFIED) {
                scope = ScopeType.EVENT;
                scope.getContext().set(String.valueOf(sourceComponentName) + "_tide_unspecified_", (Object)true);
            }
            Object value = this.mergeExternal(update.getValue(), previous);
            scope.getContext().set(sourceComponentName, value);
        }
    }

    public List<ContextUpdate> evaluateResults(Component component, Object target, boolean nothing) {
        ArrayList<ContextUpdate> resultsMap = new ArrayList<ContextUpdate>();
        if (nothing) {
            return resultsMap;
        }
        ArrayList<String> exprs = new ArrayList<String>();
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        SeamInitializer.instance();
        ScopeType[] scopeTypeArray = EVAL_SCOPE_TYPES;
        int n = EVAL_SCOPE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            ScopeType evalScopeType = scopeTypeArray[n2];
            for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval(evalScopeType).entrySet()) {
                String targetComponentName;
                if (!me.getValue().booleanValue()) continue;
                ContextResult res = me.getKey();
                Component targetComponent = TideInit.lookupComponent(res.getComponentName());
                String string = targetComponentName = targetComponent != null ? targetComponent.getName() : res.getComponentName();
                if (res.getExpression() != null && component != null && targetComponent != null && !component.getName().equals(targetComponentName)) continue;
                int idx = 0;
                boolean add = true;
                while (idx >= 0) {
                    String ex;
                    idx = res.getExpression() != null ? res.getExpression().indexOf(".", idx + 1) : -1;
                    String expr = idx > 0 ? res.getExpression().substring(0, idx) : res.getExpression();
                    String string2 = ex = expr != null ? String.valueOf(res.getComponentName()) + "." + expr : res.getComponentName();
                    if (exprs.contains(ex)) continue;
                    this.log.debug((Object)"After invocation: evaluating expression #0", new Object[]{ex});
                    String[] path = expr != null ? expr.split("\\.") : new String[]{};
                    try {
                        Object value = null;
                        ScopeType scopeType = res instanceof ScopedContextResult ? ((ScopedContextResult)res).getScope() : ScopeType.UNSPECIFIED;
                        Boolean restrict = res.getRestrict();
                        Init.FactoryMethod factoryMethod = null;
                        Init.FactoryExpression factoryExpression = null;
                        if (targetComponent == null && (factoryExpression = TideInit.lookupFactoryExpression(res.getComponentName())) == null) {
                            factoryMethod = TideInit.lookupFactory(res.getComponentName());
                        }
                        if (targetComponent != null) {
                            if (component != null && component.getName().equals(targetComponent.getName())) {
                                value = target;
                                scopeType = targetComponent.getScope();
                            } else if (ScopeType.UNSPECIFIED.equals((Object)scopeType)) {
                                value = Component.getInstance((String)targetComponent.getName());
                                scopeType = targetComponent.getScope();
                                if (ScopeType.STATELESS.equals((Object)scopeType)) {
                                    scopeType = ScopeType.EVENT;
                                }
                                if (value != null && config.isComponentTideDisabled(targetComponentName, targetComponent.getBeanClass(), value)) {
                                    add = false;
                                }
                            } else {
                                value = Component.getInstance((String)targetComponent.getName(), (ScopeType)scopeType);
                                if (value != null && config.isComponentTideDisabled(targetComponentName, value.getClass(), value)) {
                                    add = false;
                                }
                            }
                            restrict = targetComponent.beanClassHasAnnotation(Restrict.class);
                        } else if (factoryExpression != null) {
                            Component factoryComponent;
                            String expressionString = factoryExpression.getMethodBinding() != null ? factoryExpression.getMethodBinding().getExpressionString() : factoryExpression.getValueBinding().getExpressionString();
                            int iedx = expressionString.indexOf(".");
                            String expressionBaseName = expressionString.substring(2, iedx);
                            if (ScopeType.UNSPECIFIED.equals((Object)scopeType)) {
                                value = Component.getInstance((String)res.getComponentName());
                                scopeType = factoryExpression.getScope();
                                if (ScopeType.STATELESS.equals((Object)scopeType)) {
                                    scopeType = ScopeType.EVENT;
                                }
                                if (value != null && config.isComponentTideDisabled(expressionBaseName, value.getClass(), value)) {
                                    add = false;
                                }
                            } else {
                                value = Component.getInstance((String)res.getComponentName(), (ScopeType)scopeType);
                                if (value != null && config.isComponentTideDisabled(expressionBaseName, value.getClass(), value)) {
                                    add = false;
                                }
                            }
                            restrict = (factoryComponent = TideInit.lookupComponent(expressionBaseName)) != null ? factoryComponent.beanClassHasAnnotation(Restrict.class) : false;
                        } else if (factoryMethod != null) {
                            if (ScopeType.UNSPECIFIED.equals((Object)scopeType)) {
                                value = Component.getInstance((String)factoryMethod.getMethod().getAnnotation(Factory.class).value());
                                scopeType = factoryMethod.getScope();
                                if (ScopeType.STATELESS.equals((Object)scopeType)) {
                                    scopeType = ScopeType.EVENT;
                                }
                                if (value != null && config.isComponentTideDisabled(factoryMethod.getComponent().getName(), factoryMethod.getComponent().getBeanClass(), value)) {
                                    add = false;
                                }
                            } else {
                                value = Component.getInstance((String)res.getComponentName(), (ScopeType)scopeType);
                                if (value != null && config.isComponentTideDisabled(factoryMethod.getComponent().getName(), value.getClass(), value)) {
                                    add = false;
                                }
                            }
                            restrict = factoryMethod.getComponent().beanClassHasAnnotation(Restrict.class);
                        } else {
                            Object[] val = AbstractSeamServiceContext.lookupInStatefulContexts(res.getComponentName(), scopeType);
                            if (val != null) {
                                value = val[0];
                                scopeType = (ScopeType)val[1];
                                if (value != null && config.isComponentTideDisabled(res.getComponentName(), value.getClass(), value)) {
                                    add = false;
                                }
                            }
                        }
                        if (add) {
                            int i = 0;
                            while (i < path.length) {
                                if (value == null) break;
                                Method getter = Reflections.getGetterMethod(value.getClass(), (String)path[i]);
                                value = org.jboss.seam.util.Reflections.invoke((Method)getter, (Object)value, (Object[])new Object[0]);
                                ++i;
                            }
                            this.getResultsEval(scopeType).put(res, false);
                            if (value instanceof TideDataModel) {
                                value = ((TideDataModel)((Object)value)).getWrappedData();
                            } else if (value != null && classGetter != null) {
                                classGetter.initialize(null, null, value);
                                if (res.getExpression() != null) {
                                    String[] fullPath = res.getExpression().split("\\.");
                                    Object v = value;
                                    int i2 = path.length;
                                    while (i2 < fullPath.length) {
                                        Method getter = Reflections.getGetterMethod(v.getClass(), (String)fullPath[i2]);
                                        if ((v = org.jboss.seam.util.Reflections.invoke((Method)getter, (Object)v, (Object[])new Object[0])) == null) break;
                                        classGetter.initialize(null, null, v);
                                        ++i2;
                                    }
                                }
                            }
                            boolean inConversation = scopeType == ScopeType.CONVERSATION;
                            resultsMap.add(new ContextUpdate(res.getComponentName(), expr, value, inConversation, Boolean.TRUE.equals(restrict)));
                            add = false;
                        }
                        exprs.add(ex);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not evaluate result expression: " + ex, e);
                    }
                }
                me.setValue(Boolean.FALSE);
            }
            ++n2;
        }
        return resultsMap;
    }

    public Object invokeAsynchronous(AsyncContext asyncContext, String targetComponentName, String methodName, Class<?>[] paramTypes, Object[] params) {
        Method method;
        this.setAsyncContext(asyncContext);
        Contexts.getEventContext().remove("org.jboss.seam.async.AsynchronousIntercepter.REENTRANT");
        Component component = TideInit.lookupComponent(targetComponentName);
        for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval(component.getScope()).entrySet()) {
            if (!me.getKey().getComponentName().equals(targetComponentName)) continue;
            me.setValue(Boolean.TRUE);
        }
        Object target = Component.getInstance((String)targetComponentName);
        try {
            method = target.getClass().getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException(nsme);
        }
        Object result = org.jboss.seam.util.Reflections.invokeAndWrap((Method)method, (Object)target, (Object[])params);
        this.sendEvent(targetComponentName);
        return result;
    }

    protected ITidePersistenceManager getTidePersistenceManager(boolean create) {
        return SeamInitializer.instance().getTidePersistenceManager();
    }

    public static Object[] lookupInStatefulContexts(String name, ScopeType scope) {
        Object[] objectArray;
        Object result;
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.METHOD.equals((Object)scope)) && Contexts.isMethodContextActive() && (result = Contexts.getMethodContext().get(name)) != null) {
            return new Object[]{result, Contexts.getMethodContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.EVENT.equals((Object)scope)) && Contexts.isEventContextActive() && (result = Contexts.getEventContext().get(name)) != null) {
            return new Object[]{result, Contexts.getEventContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.PAGE.equals((Object)scope)) && Contexts.isPageContextActive() && (result = Contexts.getPageContext().get(name)) != null) {
            return new Object[]{result, Contexts.getPageContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.CONVERSATION.equals((Object)scope)) && Contexts.isConversationContextActive() && (result = Contexts.getConversationContext().get(name)) != null) {
            return new Object[]{result, Contexts.getConversationContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.SESSION.equals((Object)scope)) && Contexts.isSessionContextActive() && (result = Contexts.getSessionContext().get(name)) != null) {
            return new Object[]{result, Contexts.getSessionContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.BUSINESS_PROCESS.equals((Object)scope)) && Contexts.isBusinessProcessContextActive() && (result = Contexts.getBusinessProcessContext().get(name)) != null) {
            return new Object[]{result, Contexts.getBusinessProcessContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.APPLICATION.equals((Object)scope)) && Contexts.isApplicationContextActive() && (result = Contexts.getApplicationContext().get(name)) != null) {
            return new Object[]{result, Contexts.getApplicationContext().getType()};
        }
        if (ScopeType.UNSPECIFIED.equals((Object)scope)) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[1] = scope;
        }
        return objectArray;
    }
}

