package org.granite.seam21;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.granite.config.GraniteConfig;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.webapp.AMFEndpoint;
import org.granite.util.XMap;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.web.AbstractFilter;


@Scope( ScopeType.APPLICATION )
@Name( "org.granite.seam.flexFilter" )
@Startup
@Install( precedence = Install.BUILT_IN, value = false, classDependencies = { "org.granite.seam21.Seam21GraniteConfig" } )
@BypassInterceptors
@org.jboss.seam.annotations.web.Filter
public class FlexFilter extends AbstractFilter
{

    private static final Logger log = Logger.getLogger( FlexFilter.class );

    private FilterConfig config = null;
    private GraniteConfig graniteConfig = null;
    private ServicesConfig servicesConfig = null;

    private List<String> tideRoles = null;
    private List<String> tideAnnotations = null;
    private List<Class<? extends ExceptionConverter>> exceptionConverters = null;
    private AMF3MessageInterceptor amf3MessageInterceptor = null;
    private boolean tide = false;


    @Override
    public void init( FilterConfig config )
    {
        this.config = config;
    }


    @Create
    public void seamInit()
    {
        Seam21GraniteConfig seam21GraniteConfig = (Seam21GraniteConfig) Component.getInstance( Seam21GraniteConfig.class, true );

        this.graniteConfig = seam21GraniteConfig.getGraniteConfig();
        if( tideAnnotations != null )
        {
            for( String ta : tideAnnotations )
            {
                try
                {
                    this.graniteConfig.getTideComponentMatchers().add( new TideComponentAnnotatedWithMatcher( ta, false ) );
                    log.debug( "Enabled components annotated with {0} for Tide remoting", ta );
                }
                catch( Exception e )
                {
                    log.error( e, "Could not add tide-component annotation {0}", ta );
                }
            }
        }
        if( exceptionConverters != null )
        {
            for( Class<? extends ExceptionConverter> ec : exceptionConverters )
            {
                this.graniteConfig.registerExceptionConverter( ec );
                log.debug( "Registered exception converter {0}", ec );
            }
        }
        if( amf3MessageInterceptor != null )
        {
            this.graniteConfig.setAmf3MessageInterceptor( amf3MessageInterceptor );
        }

        servicesConfig = seam21GraniteConfig.getServicesConfig();

        Channel channel = new Channel( "graniteamf", "mx.messaging.channels.AMFChannel",
                                       new EndPoint( "http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint" ),
                                       new XMap() );
        servicesConfig.addChannel( channel );

        if( tide )
        {
            Factory factory = new Factory( "tide-seam-factory", "org.granite.tide.seam.SeamServiceFactory", new XMap() );
            servicesConfig.addFactory( factory );

            Service service = new Service( "granite-service", "flex.messaging.services.RemotingService",
                                           "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>() );
            List<String> channelIds = new ArrayList<String>();
            channelIds.add( "graniteamf" );
            Destination destination = new Destination( "seam", channelIds, new XMap(), tideRoles, null, null );
            destination.getProperties().put( "factory", "tide-seam-factory" );
            service.getDestinations().put( "seam", destination );
            servicesConfig.addService( service );

            log.info( "Registered Tide/Seam service factory and destination" );
        }
        else
        {
            Factory factory = new Factory( "seam-factory", "org.granite.seam.SeamServiceFactory", new XMap() );
            servicesConfig.addFactory( factory );

            Service service = new Service( "granite-service", "flex.messaging.services.RemotingService",
                                           "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>() );
            servicesConfig.addService( service );

            servicesConfig.scan( null );

            log.info( "Registered Seam service factory" );
        }
    }

    public void setTideRoles( List<String> tideRoles )
    {
        this.tideRoles = tideRoles;
    }

    public void setTideAnnotations( List<String> tideAnnotations )
    {
        this.tideAnnotations = tideAnnotations;
    }

    public void setExceptionConverters( List<Class<? extends ExceptionConverter>> exceptionConverters )
    {
        this.exceptionConverters = exceptionConverters;
    }

    public void setAmf3MessageInterceptor( AMF3MessageInterceptor amf3MessageInterceptor )
    {
        this.amf3MessageInterceptor = amf3MessageInterceptor;
    }

    public void setTide( boolean tide )
    {
        this.tide = tide;
    }


    public void doFilter( ServletRequest request, ServletResponse response, FilterChain chain )
        throws IOException, ServletException
    {
        if( isMappedToCurrentRequestPath( request ) )
        {
            AMFEndpoint.service( graniteConfig, servicesConfig, config.getServletContext(),
                                 (HttpServletRequest) request, (HttpServletResponse) response );
        }
        else
        {
            chain.doFilter( request, response );
        }
    }
}