/*
 * Decompiled with CFR 0.152.
 */
package org.granite.seam.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.security.auth.login.LoginException;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.NotLoggedInException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamSecurityService
extends AbstractSecurityService {
    private static final Logger log = Logger.getLogger(SeamSecurityService.class);

    public void configure(Map<String, String> params) {
    }

    public void login(Object credentials) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials);
        Contexts.getSessionContext().set("org.granite.seam.login", (Object)Boolean.TRUE);
        Identity identity = Identity.instance();
        if (identity.isLoggedIn(false) && !decoded[0].equals(identity.getUsername())) {
            try {
                Method method = identity.getClass().getDeclaredMethod("unAuthenticate", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)identity, new Object[0]);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Could not call unAuthenticate method on: %s", new Object[]{identity.getClass()});
            }
        }
        identity.setUsername(decoded[0]);
        identity.setPassword(decoded[1]);
        try {
            identity.authenticate();
        }
        catch (LoginException e) {
            identity.login();
            throw SecurityServiceException.newInvalidCredentialsException((String)"User authentication failed");
        }
    }

    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        if (context.getDestination().isSecured()) {
            Identity identity = Identity.instance();
            if (!identity.isLoggedIn()) {
                throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
            }
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (!identity.hasRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException((String)"User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (t instanceof NotLoggedInException) {
                    throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
                }
                if (!(t instanceof SecurityException) && !(t instanceof AuthorizationException) && !"javax.ejb.EJBAccessException".equals(t.getClass().getName())) continue;
                throw SecurityServiceException.newAccessDeniedException((String)t.getMessage());
            }
            throw e;
        }
    }

    public void logout() throws SecurityServiceException {
        Identity.instance().logout();
    }

    public void handleSecurityException(SecurityServiceException e) {
        FacesMessages.afterPhase();
        FacesMessages.instance().beforeRenderResponse();
        List facesMessages = FacesMessages.instance().getCurrentMessages();
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass("org.granite.tide.TideMessage");
            Constructor<?> co = c.getConstructor(String.class, String.class, String.class);
            ArrayList tideMessages = new ArrayList(facesMessages.size());
            for (FacesMessage fm : facesMessages) {
                String severity = null;
                if (fm.getSeverity() == FacesMessage.SEVERITY_INFO) {
                    severity = "INFO";
                } else if (fm.getSeverity() == FacesMessage.SEVERITY_WARN) {
                    severity = "WARNING";
                } else if (fm.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                    severity = "ERROR";
                } else if (fm.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                    severity = "FATAL";
                }
                tideMessages.add(co.newInstance(severity, fm.getSummary(), fm.getDetail()));
            }
            e.getExtendedData().put("messages", tideMessages);
        }
        catch (Throwable t) {
            e.getExtendedData().put("messages", facesMessages);
        }
    }
}

