/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam21;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.granite.tide.TideMessage;
import org.granite.tide.seam.AbstractSeamServiceContext;
import org.granite.tide.seam21.TideStatusMessages;
import org.granite.util.Reflections;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.international.StatusMessages;

@Scope(value=ScopeType.SESSION)
@Name(value="org.granite.tide.seam.serviceContext")
@Install(precedence=11)
@BypassInterceptors
public class Seam21ServiceContext
extends AbstractSeamServiceContext {
    private static final long serialVersionUID = 1L;

    protected void initTideMessages() {
        StatusMessages.instance();
    }

    protected void clearTideMessages() {
        StatusMessages statusMessages = StatusMessages.instance();
        if (statusMessages instanceof TideStatusMessages) {
            ((TideStatusMessages)statusMessages).clear();
        } else {
            try {
                Reflections.invoke((Method)statusMessages.getClass().getMethod("clear", new Class[0]), (Object)statusMessages, (Object[])new Object[0]);
            }
            catch (Exception e) {
                this.log.error((Object)"Could not clear list of TideMessages", (Throwable)e, new Object[0]);
            }
        }
    }

    protected org.granite.tide.TideStatusMessages getTideMessages() {
        StatusMessages statusMessages = StatusMessages.instance();
        if (statusMessages == null) {
            return org.granite.tide.TideStatusMessages.EMPTY_STATUS_MESSAGES;
        }
        try {
            Method m = StatusMessages.class.getDeclaredMethod("doRunTasks", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)statusMessages, new Object[0]);
            Method m2 = StatusMessages.class.getDeclaredMethod("getMessages", new Class[0]);
            m2.setAccessible(true);
            List messages = (List)m2.invoke((Object)statusMessages, new Object[0]);
            ArrayList<TideMessage> tideMessages = new ArrayList<TideMessage>(messages.size());
            this.log.debug((Object)"Found Messages: %b", new Object[]{!messages.isEmpty()});
            for (StatusMessage msg : messages) {
                String severity = null;
                if (msg.getSeverity() == StatusMessage.Severity.INFO) {
                    severity = "INFO";
                } else if (msg.getSeverity() == StatusMessage.Severity.WARN) {
                    severity = "WARNING";
                } else if (msg.getSeverity() == StatusMessage.Severity.ERROR) {
                    severity = "ERROR";
                } else if (msg.getSeverity() == StatusMessage.Severity.FATAL) {
                    severity = "FATAL";
                }
                tideMessages.add(new TideMessage(severity, msg.getSummary(), msg.getDetail()));
            }
            Method m3 = StatusMessages.class.getDeclaredMethod("getKeyedMessages", new Class[0]);
            m3.setAccessible(true);
            Map keyedMessages = (Map)m3.invoke((Object)statusMessages, new Object[0]);
            HashMap tideKeyedMessages = new HashMap(keyedMessages.size());
            for (Map.Entry me : keyedMessages.entrySet()) {
                ArrayList<TideMessage> tmsgs = new ArrayList<TideMessage>(((List)me.getValue()).size());
                for (StatusMessage msg : (List)me.getValue()) {
                    String severity = null;
                    if (msg.getSeverity() == StatusMessage.Severity.INFO) {
                        severity = "INFO";
                    } else if (msg.getSeverity() == StatusMessage.Severity.WARN) {
                        severity = "WARNING";
                    } else if (msg.getSeverity() == StatusMessage.Severity.ERROR) {
                        severity = "ERROR";
                    } else if (msg.getSeverity() == StatusMessage.Severity.FATAL) {
                        severity = "FATAL";
                    }
                    tmsgs.add(new TideMessage(severity, msg.getSummary(), msg.getDetail()));
                }
                tideKeyedMessages.put(me.getKey(), tmsgs);
            }
            return new org.granite.tide.TideStatusMessages(tideMessages, tideKeyedMessages);
        }
        catch (Exception e) {
            this.log.error((Object)"Could not get status messages", (Throwable)e, new Object[0]);
            return org.granite.tide.TideStatusMessages.EMPTY_STATUS_MESSAGES;
        }
    }
}

