/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam21;

import flex.messaging.messages.Message;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.granite.config.flex.Destination;
import org.granite.logging.Logger;
import org.granite.messaging.service.ExtendedServiceExceptionHandler;
import org.granite.messaging.service.ServiceException;
import org.granite.tide.TideMessage;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.international.StatusMessages;

public class Seam21ServiceExceptionHandler
extends ExtendedServiceExceptionHandler {
    private static final long serialVersionUID = -1L;
    private static final Logger log = Logger.getLogger(Seam21ServiceExceptionHandler.class);

    public Seam21ServiceExceptionHandler() {
        super(true);
    }

    public Seam21ServiceExceptionHandler(boolean logException) {
        super(logException);
    }

    protected ServiceException getServiceException(Message request, Destination destination, String method, Throwable t) {
        ServiceException se = super.getServiceException(request, destination, method, t);
        StatusMessages statusMessages = StatusMessages.instance();
        if (statusMessages != null) {
            ArrayList<TideMessage> tideMessages = new ArrayList<TideMessage>();
            HashMap tideKeyedMessages = new HashMap();
            try {
                Method m = StatusMessages.class.getDeclaredMethod("doRunTasks", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)statusMessages, new Object[0]);
                Method m2 = StatusMessages.class.getDeclaredMethod("getMessages", new Class[0]);
                m2.setAccessible(true);
                List messages = (List)m2.invoke((Object)statusMessages, new Object[0]);
                for (StatusMessage msg : messages) {
                    String severity = null;
                    if (msg.getSeverity() == StatusMessage.Severity.INFO) {
                        severity = "INFO";
                    } else if (msg.getSeverity() == StatusMessage.Severity.WARN) {
                        severity = "WARNING";
                    } else if (msg.getSeverity() == StatusMessage.Severity.ERROR) {
                        severity = "ERROR";
                    } else if (msg.getSeverity() == StatusMessage.Severity.FATAL) {
                        severity = "FATAL";
                    }
                    tideMessages.add(new TideMessage(severity, msg.getSummary(), msg.getDetail()));
                }
                Method m3 = StatusMessages.class.getDeclaredMethod("getKeyedMessages", new Class[0]);
                m3.setAccessible(true);
                Map keyedMessages = (Map)m3.invoke((Object)statusMessages, new Object[0]);
                for (Map.Entry me : keyedMessages.entrySet()) {
                    ArrayList<TideMessage> tmsgs = new ArrayList<TideMessage>(((List)me.getValue()).size());
                    for (StatusMessage msg : (List)me.getValue()) {
                        String severity = null;
                        if (msg.getSeverity() == StatusMessage.Severity.INFO) {
                            severity = "INFO";
                        } else if (msg.getSeverity() == StatusMessage.Severity.WARN) {
                            severity = "WARNING";
                        } else if (msg.getSeverity() == StatusMessage.Severity.ERROR) {
                            severity = "ERROR";
                        } else if (msg.getSeverity() == StatusMessage.Severity.FATAL) {
                            severity = "FATAL";
                        }
                        tmsgs.add(new TideMessage(severity, msg.getSummary(), msg.getDetail()));
                    }
                    tideKeyedMessages.put(me.getKey(), tmsgs);
                }
            }
            catch (Exception e) {
                log.error("Could not get status messages", new Object[]{e});
            }
            se.getExtendedData().put("messages", tideMessages);
            se.getExtendedData().put("keyedMessages", tideKeyedMessages);
        }
        return se;
    }
}

