/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import java.util.concurrent.ConcurrentHashMap;
import org.granite.tide.seam.UserEvents;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;

@Name(value="org.granite.tide.seam.userEvents")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@AutoCreate
public class TideUserEvents {
    private static final long serialVersionUID = -5395975397632138270L;
    private ConcurrentHashMap<String, UserEvents> userEventsMap = new ConcurrentHashMap();

    public synchronized void registerEventType(String sessionId, String eventType) {
        UserEvents userEvents = this.userEventsMap.get(sessionId);
        if (userEvents == null) {
            userEvents = new UserEvents();
            this.userEventsMap.put(sessionId, userEvents);
        }
        userEvents.addEventType(eventType);
    }

    public void unregisterSession(String sessionId) {
        this.userEventsMap.remove(sessionId);
    }

    public UserEvents getUserEvents(String sessionId) {
        return this.userEventsMap.get(sessionId);
    }

    public boolean hasEventType(String sessionId, String eventType) {
        UserEvents userEvents = this.userEventsMap.get(sessionId);
        if (userEvents == null) {
            return false;
        }
        return userEvents.hasEventType(eventType);
    }

    public static TideUserEvents instance() {
        return (TideUserEvents)Component.getInstance(TideUserEvents.class, (ScopeType)ScopeType.APPLICATION);
    }
}

