/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam.async;

import flex.messaging.messages.AsyncMessage;
import javax.servlet.ServletContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.tide.async.AsyncPublisher;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.ServletLifecycle;

@Name(value="org.granite.tide.seam.async.publisher")
@Install(precedence=10, classDependencies={"org.granite.gravity.Gravity"})
@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@AutoCreate
public class SeamAsyncPublisher
implements AsyncPublisher {
    private static final long serialVersionUID = -5395975397632138270L;
    public static final String DESTINATION_NAME = "seamAsync";

    private Gravity getGravity() {
        return GravityManager.getGravity((ServletContext)ServletLifecycle.getServletContext());
    }

    public void initThread() {
        Gravity gravity = this.getGravity();
        if (gravity == null) {
            throw new RuntimeException("Gravity service not configured, it is required for asynchronous event publishing");
        }
        gravity.initThread();
    }

    public void publishMessage(String sessionId, Object body) {
        AsyncMessage message = new AsyncMessage();
        message.setHeader("DSSubtopic", (Object)("tide.events." + sessionId));
        message.setDestination(DESTINATION_NAME);
        message.setBody(body);
        this.getGravity().publishMessage(message);
    }
}

