/*
 * Decompiled with CFR 0.152.
 */
package org.granite.seam21;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.service.tide.TideComponentInstanceOfMatcher;
import org.granite.messaging.service.tide.TideComponentNameMatcher;
import org.granite.messaging.service.tide.TideComponentTypeMatcher;
import org.granite.messaging.webapp.AMFEndpoint;
import org.granite.seam21.Seam21GraniteConfig;
import org.granite.util.XMap;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.web.AbstractFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.granite.seam.serverFilter")
@Startup
@Install(precedence=0, value=false, classDependencies={"org.granite.seam21.Seam21GraniteConfig"})
@BypassInterceptors
@Filter
public class ServerFilter
extends AbstractFilter {
    private static final Logger log = Logger.getLogger(ServerFilter.class);
    private FilterConfig config = null;
    private GraniteConfig graniteConfig = null;
    private ServicesConfig servicesConfig = null;
    private List<String> tideRoles = null;
    private List<String> tideAnnotations = null;
    private List<String> tideInterfaces = null;
    private List<String> tideNames = null;
    private List<String> tideTypes = null;
    private List<Class<? extends ExceptionConverter>> exceptionConverters = null;
    private AMF3MessageInterceptor amf3MessageInterceptor = null;
    private boolean tide = false;

    public ServerFilter() {
        this.setUrlPattern("/graniteamf/*");
    }

    public void init(FilterConfig config) {
        this.config = config;
    }

    @Create
    public void seamInit() {
        Service service;
        Factory factory;
        Seam21GraniteConfig seam21GraniteConfig = (Seam21GraniteConfig)((Object)Component.getInstance(Seam21GraniteConfig.class, (boolean)true));
        this.graniteConfig = seam21GraniteConfig.getGraniteConfig();
        if (this.tideAnnotations != null) {
            for (String string : this.tideAnnotations) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentAnnotatedWithMatcher(string, false));
                    log.debug("Enabled components annotated with %s for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component annotation %s", new Object[]{string});
                }
            }
        }
        if (this.tideInterfaces != null) {
            for (String string : this.tideInterfaces) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentInstanceOfMatcher(string, false));
                    log.debug("Enabled components extending %s for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component interface %s", new Object[]{string});
                }
            }
        }
        if (this.tideNames != null) {
            for (String string : this.tideNames) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentNameMatcher(string, false));
                    log.debug("Enabled components named like %s for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component name %s", new Object[]{string});
                }
            }
        }
        if (this.tideTypes != null) {
            for (String string : this.tideTypes) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentTypeMatcher(string, false));
                    log.debug("Enabled components with type %s for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component type %s", new Object[]{string});
                }
            }
        }
        if (this.exceptionConverters != null) {
            for (Class clazz : this.exceptionConverters) {
                this.graniteConfig.registerExceptionConverter(clazz);
                log.debug("Registered exception converter %s", new Object[]{clazz});
            }
        }
        if (this.amf3MessageInterceptor != null) {
            this.graniteConfig.setAmf3MessageInterceptor(this.amf3MessageInterceptor);
        }
        this.servicesConfig = seam21GraniteConfig.getServicesConfig();
        Channel channel = this.servicesConfig.findChannelById("graniteamf");
        if (channel == null) {
            Channel channel2 = new Channel("graniteamf", "mx.messaging.channels.AMFChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
            this.servicesConfig.addChannel(channel2);
        }
        if (this.tide) {
            Destination destination;
            factory = this.servicesConfig.findFactoryById("tide-seam-factory");
            if (factory == null) {
                factory = new Factory("tide-seam-factory", "org.granite.tide.seam.SeamServiceFactory", new XMap());
                this.servicesConfig.addFactory(factory);
            }
            if ((service = this.servicesConfig.findServiceById("granite-service")) == null) {
                service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap());
            }
            if ((destination = this.servicesConfig.findDestinationById("flex.messaging.messages.RemotingMessage", "seam")) == null) {
                ArrayList<String> channelIds = new ArrayList<String>();
                channelIds.add("graniteamf");
                destination = new Destination("seam", channelIds, new XMap(), this.tideRoles, null, null);
                destination.getProperties().put("factory", factory.getId());
                destination.getProperties().put("validator-name", "tideValidator");
                service.getDestinations().put(destination.getId(), destination);
                this.servicesConfig.addService(service);
            }
            log.info("Registered Tide/Seam service factory and destination", new Object[0]);
        } else {
            factory = new Factory("seam-factory", "org.granite.seam.SeamServiceFactory", new XMap());
            this.servicesConfig.addFactory(factory);
            service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap());
            this.servicesConfig.addService(service);
            this.servicesConfig.scan(null);
            log.info("Registered Seam service factory", new Object[0]);
        }
    }

    public void setTideRoles(List<String> tideRoles) {
        this.tideRoles = tideRoles;
    }

    public void setTideAnnotations(List<String> tideAnnotations) {
        this.tideAnnotations = tideAnnotations;
    }

    public void setTideInterfaces(List<String> tideInterfaces) {
        this.tideInterfaces = tideInterfaces;
    }

    public void setTideNames(List<String> tideNames) {
        this.tideNames = tideNames;
    }

    public void setTideTypes(List<String> tideTypes) {
        this.tideTypes = tideTypes;
    }

    public void setExceptionConverters(List<Class<? extends ExceptionConverter>> exceptionConverters) {
        this.exceptionConverters = exceptionConverters;
    }

    public void setAmf3MessageInterceptor(AMF3MessageInterceptor amf3MessageInterceptor) {
        this.amf3MessageInterceptor = amf3MessageInterceptor;
    }

    public void setTide(boolean tide) {
        this.tide = tide;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isMappedToCurrentRequestPath(request)) {
            AMFEndpoint.service((GraniteConfig)this.graniteConfig, (ServicesConfig)this.servicesConfig, (ServletContext)this.config.getServletContext(), (HttpServletRequest)((HttpServletRequest)request), (HttpServletResponse)((HttpServletResponse)response));
        } else {
            chain.doFilter(request, response);
        }
    }
}

