/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.granite.logging.Logger;
import org.granite.tide.cdi.CDIServiceContext;
import org.granite.tide.cdi.TideComponent;
import org.granite.tide.cdi.TideInstrumentedBeans;
import org.granite.tide.cdi.TideInvocation;
import org.granite.tide.invocation.ContextResult;
import org.granite.tide.invocation.ContextUpdate;
import org.granite.util.Reflections;

@TideComponent
@Interceptor
public class TideComponentInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TideComponentInterceptor.class);
    private boolean reentrant;
    @Inject
    private CDIServiceContext tideContext;
    @Inject
    private TideInstrumentedBeans instrumentedBeans;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object doAround(InvocationContext invocation) throws Exception {
        if (this.reentrant) {
            return invocation.proceed();
        }
        TideInvocation tideInvocation = TideInvocation.get();
        if (this.tideContext == null || tideInvocation == null || tideInvocation.isLocked()) {
            return invocation.proceed();
        }
        try {
            ContextResult cr;
            this.reentrant = true;
            boolean evaluate = false;
            if (tideInvocation.isEnabled() && !tideInvocation.isUpdated()) {
                ArrayList<ContextUpdate> updates = new ArrayList<ContextUpdate>(tideInvocation.getUpdates());
                tideInvocation.updated();
                this.tideContext.restoreContext(updates, invocation.getTarget());
                evaluate = true;
            }
            ArrayList<Object[]> crs = new ArrayList<Object[]>();
            Bean<?> bean = this.instrumentedBeans.getBean(invocation.getTarget().getClass());
            if (bean == null) {
                log.warn("Instrumented Bean not found for class " + invocation.getTarget().getClass(), new Object[0]);
            } else {
                String componentName = bean.getName();
                for (Map.Entry<ContextResult, Boolean> entry : this.tideContext.getResultsEval().entrySet()) {
                    cr = entry.getKey();
                    if (cr.getExpression() == null || (cr.getComponentName() == null || !cr.getComponentName().equals(componentName)) && (cr.getComponentClassName() == null || !bean.getTypes().contains(cr.getComponentClass()))) continue;
                    int idx = cr.getExpression().indexOf(46);
                    String propName = idx >= 0 ? cr.getExpression().substring(0, idx) : cr.getExpression();
                    Method getter = null;
                    try {
                        getter = Reflections.getGetterMethod(invocation.getTarget().getClass(), (String)propName);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (getter == null) continue;
                    crs.add(new Object[]{entry, getter, getter.invoke(invocation.getTarget(), new Object[0])});
                }
            }
            Object result = invocation.proceed();
            for (Object[] objectArray : crs) {
                Method getter = (Method)objectArray[1];
                Object newValue = getter.invoke(invocation.getTarget(), new Object[0]);
                if ((newValue != null || objectArray[2] == null) && (newValue == null || newValue.equals(objectArray[2]))) continue;
                ((Map.Entry)objectArray[0]).setValue(true);
            }
            for (Map.Entry<Object, Boolean> entry : this.tideContext.getResultsEval().entrySet()) {
                cr = (ContextResult)entry.getKey();
                if (cr.getExpression() != null) continue;
                if (cr.getComponentClassName() != null && this.instrumentedBeans.isProducedBy(cr.getComponentClass(), invocation.getTarget().getClass())) {
                    entry.setValue(true);
                }
                if (cr.getComponentName() == null || !this.instrumentedBeans.isProducedBy(cr.getComponentName(), invocation.getTarget().getClass())) continue;
                entry.setValue(true);
            }
            if (evaluate) {
                tideInvocation.evaluated(this.tideContext.evaluateResults(invocation.getTarget(), false));
            }
            Object object = result;
            return object;
        }
        finally {
            this.reentrant = false;
        }
    }
}

