/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import org.granite.tide.cdi.UserEvents;

@ApplicationScoped
public class TideUserEvents
implements Serializable {
    private static final long serialVersionUID = -5395975397632138270L;
    private ConcurrentHashMap<String, UserEvents> userEventsMap = new ConcurrentHashMap();

    public void registerEventType(String sessionId, Class<?> eventType) {
        UserEvents tmpUserEvents;
        UserEvents userEvents = this.userEventsMap.get(sessionId);
        if (userEvents == null && (tmpUserEvents = this.userEventsMap.putIfAbsent(sessionId, userEvents = new UserEvents())) != null) {
            userEvents = tmpUserEvents;
        }
        userEvents.addEventType(eventType);
    }

    public void unregisterSession(String sessionId) {
        this.userEventsMap.remove(sessionId);
    }

    public UserEvents getUserEvents(String sessionId) {
        return this.userEventsMap.get(sessionId);
    }

    public boolean hasEventType(String sessionId, Class<?> eventType) {
        UserEvents userEvents = this.userEventsMap.get(sessionId);
        if (userEvents == null) {
            return false;
        }
        return userEvents.hasEventType(eventType);
    }
}

