/*
 * Decompiled with CFR 0.152.
 */
package org.granite.cdi;

import flex.messaging.messages.Message;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.granite.cdi.CDIConversationManager;
import org.granite.cdi.CDIUtils;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.HttpServletRequestParamWrapper;
import org.granite.tide.cdi.ConversationState;
import org.granite.tide.cdi.EventState;
import org.granite.tide.cdi.SessionState;
import org.granite.util.TypeUtil;

public class CDIInterceptor
implements AMF3MessageInterceptor {
    private static final Logger log = Logger.getLogger(CDIInterceptor.class);
    private static final String CONVERSATION_ID = "conversationId";
    private static final String IS_LONG_RUNNING_CONVERSATION = "isLongRunningConversation";
    private static final String WAS_LONG_RUNNING_CONVERSATION_CREATED = "wasLongRunningConversationCreated";
    private static final String WAS_LONG_RUNNING_CONVERSATION_ENDED = "wasLongRunningConversationEnded";
    private final CDIConversationManager conversationManager;
    private final ServletRequestListener requestListener;
    private static final String MESSAGECOUNT_ATTR = CDIInterceptor.class.getName() + "_messageCount";
    private static final String REQUESTWRAPPER_ATTR = CDIInterceptor.class.getName() + "_requestWrapper";

    public CDIInterceptor() {
        CDIConversationManager conversationManager = null;
        ServletRequestListener listener = null;
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.jboss.weld.context.http.HttpConversationContext");
            conversationManager = (CDIConversationManager)TypeUtil.newInstance((String)"org.granite.cdi.Weld11ConversationManager", CDIConversationManager.class);
            listener = (ServletRequestListener)TypeUtil.newInstance((String)"org.jboss.weld.servlet.WeldListener", ServletRequestListener.class);
            log.info("Detected JBoss Weld 1.1+", new Object[0]);
        }
        catch (Exception e) {
            try {
                conversationManager = null;
                listener = (ServletRequestListener)TypeUtil.newInstance((String)"org.apache.webbeans.servlet.WebBeansConfigurationListener", ServletRequestListener.class);
                Field wbcField = listener.getClass().getDeclaredField("webBeansContext");
                wbcField.setAccessible(true);
                Object webBeansContext = wbcField.get(listener);
                Field lcField = listener.getClass().getDeclaredField("lifeCycle");
                lcField.setAccessible(true);
                Method wbcGetService = webBeansContext.getClass().getMethod("getService", Class.class);
                Object lifecycle = wbcGetService.invoke(webBeansContext, TypeUtil.forName((String)"org.apache.webbeans.spi.ContainerLifecycle"));
                lcField.set(listener, lifecycle);
                log.info("Detected Apache OpenWebBeans, conversation support disabled", new Object[0]);
            }
            catch (Exception f2) {
                log.warn("Unsupported CDI container, conversation support disabled", new Object[0]);
            }
        }
        this.conversationManager = conversationManager;
        this.requestListener = listener;
    }

    public void before(Message amf3RequestMessage) {
        if (log.isTraceEnabled()) {
            log.trace("Pre processing of request message: %s", new Object[]{amf3RequestMessage});
        }
        try {
            GraniteContext context = GraniteContext.getCurrentInstance();
            if (context instanceof HttpGraniteContext) {
                HttpGraniteContext httpContext = (HttpGraniteContext)context;
                if (this.requestListener != null) {
                    Integer wrapCount = (Integer)httpContext.getRequest().getAttribute(MESSAGECOUNT_ATTR);
                    if (wrapCount == null) {
                        log.debug("Clearing default container request context", new Object[0]);
                        ServletRequestEvent event = new ServletRequestEvent(httpContext.getServletContext(), (ServletRequest)httpContext.getRequest());
                        this.requestListener.requestDestroyed(event);
                        httpContext.getRequest().setAttribute(MESSAGECOUNT_ATTR, (Object)1);
                    } else {
                        httpContext.getRequest().setAttribute(MESSAGECOUNT_ATTR, (Object)(wrapCount + 1));
                    }
                    log.debug("Initializing wrapped AMF request", new Object[0]);
                    HttpServletRequestParamWrapper requestWrapper = new HttpServletRequestParamWrapper(httpContext.getRequest());
                    httpContext.getRequest().setAttribute(REQUESTWRAPPER_ATTR, (Object)requestWrapper);
                    Map headerMap = amf3RequestMessage.getHeaders();
                    if (headerMap != null && headerMap.size() > 0) {
                        for (String key : headerMap.keySet()) {
                            String value = headerMap.get(key) == null ? null : headerMap.get(key).toString();
                            if (value == null) continue;
                            requestWrapper.setParameter(key, value);
                        }
                    }
                    ServletRequestEvent event = new ServletRequestEvent(((HttpGraniteContext)context).getServletContext(), (ServletRequest)requestWrapper);
                    this.requestListener.requestInitialized(event);
                }
                BeanManager beanManager = CDIUtils.lookupBeanManager(((HttpGraniteContext)context).getServletContext());
                if (this.conversationManager != null) {
                    String conversationId = (String)amf3RequestMessage.getHeader(CONVERSATION_ID);
                    Conversation conversation = this.conversationManager.initConversation(beanManager, conversationId);
                    Bean eventBean = (Bean)beanManager.getBeans(EventState.class, new Annotation[0]).iterator().next();
                    EventState eventState = (EventState)beanManager.getReference(eventBean, EventState.class, beanManager.createCreationalContext((Contextual)eventBean));
                    if (!conversation.isTransient()) {
                        eventState.setWasLongRunning(true);
                    }
                    if (conversationId != null && conversation.isTransient()) {
                        log.debug("Starting conversation " + conversationId, new Object[0]);
                        conversation.begin(conversationId);
                    }
                    if (Boolean.TRUE.toString().equals(amf3RequestMessage.getHeader("org.granite.tide.isFirstConversationCall")) && !conversation.isTransient()) {
                        Bean csBean = (Bean)beanManager.getBeans(ConversationState.class, new Annotation[0]).iterator().next();
                        ((ConversationState)beanManager.getReference(csBean, ConversationState.class, beanManager.createCreationalContext((Contextual)csBean))).setFirstCall(true);
                    }
                }
                if (Boolean.TRUE.toString().equals(amf3RequestMessage.getHeader("org.granite.tide.isFirstCall"))) {
                    Bean ssBean = (Bean)beanManager.getBeans(SessionState.class, new Annotation[0]).iterator().next();
                    ((SessionState)beanManager.getReference(ssBean, SessionState.class, beanManager.createCreationalContext((Contextual)ssBean))).setFirstCall(true);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception while pre processing the request message.", new Object[0]);
            throw new ServiceException("Error while pre processing the request message - " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Message amf3RequestMessage, Message amf3ResponseMessage) {
        block13: {
            try {
                GraniteContext context;
                if (log.isTraceEnabled()) {
                    log.trace("Post processing of response message: %s", new Object[]{amf3ResponseMessage});
                }
                if (!((context = GraniteContext.getCurrentInstance()) instanceof HttpGraniteContext)) break block13;
                BeanManager beanManager = CDIUtils.lookupBeanManager(((HttpGraniteContext)context).getServletContext());
                try {
                    if (this.conversationManager != null && amf3ResponseMessage != null) {
                        Bean conversationBean = (Bean)beanManager.getBeans(Conversation.class, new Annotation[0]).iterator().next();
                        Conversation conversation = (Conversation)beanManager.getReference(conversationBean, Conversation.class, beanManager.createCreationalContext((Contextual)conversationBean));
                        Bean eventBean = (Bean)beanManager.getBeans(EventState.class, new Annotation[0]).iterator().next();
                        EventState eventState = (EventState)beanManager.getReference(eventBean, EventState.class, beanManager.createCreationalContext((Contextual)eventBean));
                        if (eventState.wasLongRunning() && !conversation.isTransient()) {
                            amf3ResponseMessage.setHeader(WAS_LONG_RUNNING_CONVERSATION_ENDED, (Object)true);
                        }
                        if (eventState.wasCreated() && !conversation.isTransient()) {
                            amf3ResponseMessage.setHeader(WAS_LONG_RUNNING_CONVERSATION_CREATED, (Object)true);
                        }
                        amf3ResponseMessage.setHeader(CONVERSATION_ID, (Object)conversation.getId());
                        amf3ResponseMessage.setHeader(IS_LONG_RUNNING_CONVERSATION, (Object)(!conversation.isTransient() ? 1 : 0));
                    }
                }
                finally {
                    if (this.conversationManager != null) {
                        this.conversationManager.destroyConversation(beanManager);
                    }
                    HttpGraniteContext httpContext = (HttpGraniteContext)context;
                    if (this.requestListener != null) {
                        HttpServletRequestParamWrapper requestWrapper = (HttpServletRequestParamWrapper)httpContext.getRequest().getAttribute(REQUESTWRAPPER_ATTR);
                        httpContext.getRequest().removeAttribute(REQUESTWRAPPER_ATTR);
                        ServletRequestEvent event = new ServletRequestEvent(httpContext.getServletContext(), (ServletRequest)requestWrapper);
                        this.requestListener.requestDestroyed(event);
                        log.debug("Destroying wrapped CDI AMF request", new Object[0]);
                        Integer wrapCount = (Integer)httpContext.getRequest().getAttribute(MESSAGECOUNT_ATTR);
                        if (wrapCount == 1) {
                            log.debug("Restoring default container request context", new Object[0]);
                            event = new ServletRequestEvent(((HttpGraniteContext)context).getServletContext(), (ServletRequest)httpContext.getRequest());
                            this.requestListener.requestInitialized(event);
                            httpContext.getRequest().removeAttribute(MESSAGECOUNT_ATTR);
                        } else {
                            httpContext.getRequest().setAttribute(MESSAGECOUNT_ATTR, (Object)(wrapCount - 1));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception while post processing the response message.", new Object[0]);
                throw new ServiceException("Error while post processing the response message - " + e.getMessage());
            }
        }
    }
}

