/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import org.granite.cdi.CDIUtils;
import org.granite.cdi.GravityFactory;
import org.granite.config.ConfigProvider;
import org.granite.gravity.Gravity;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceFactory;
import org.granite.tide.cdi.CDIServiceFactory;
import org.granite.tide.cdi.Identity;

public class CDIConfigProvider
implements ConfigProvider {
    private static final Logger log = Logger.getLogger(CDIConfigProvider.class);
    protected BeanManager beanManager;

    public CDIConfigProvider(ServletContext servletContext) {
        this.beanManager = CDIUtils.lookupBeanManager(servletContext);
    }

    public Boolean useTide() {
        return true;
    }

    public String getType() {
        return "server";
    }

    public Class<? extends ServiceFactory> getFactoryClass() {
        return CDIServiceFactory.class;
    }

    public <T> T findInstance(Class<T> type) {
        Set beans = this.beanManager.getBeans(type, new Annotation[0]);
        if (beans.size() == 1) {
            Bean bean = (Bean)beans.iterator().next();
            CreationalContext cc = this.beanManager.createCreationalContext((Contextual)bean);
            return (T)this.beanManager.getReference(bean, type, cc);
        }
        return null;
    }

    public <T> Set<T> findInstances(Class<T> type) {
        Set beans = this.beanManager.getBeans(type, new Annotation[0]);
        HashSet<Object> instances = new HashSet<Object>(beans.size());
        for (Bean bean : beans) {
            CreationalContext cc = this.beanManager.createCreationalContext((Contextual)bean);
            instances.add(this.beanManager.getReference(bean, type, cc));
        }
        return instances;
    }

    public Class<?>[] getTideInterfaces() {
        return new Class[]{Identity.class};
    }

    public Class<? extends Annotation>[] getTideAnnotations() {
        return new Class[0];
    }

    public void initGravity(Gravity gravity) {
        GravityFactory gravityFactory = this.findInstance(GravityFactory.class);
        gravityFactory.setGravity(gravity);
        log.info("Registered Gravity bean", new Object[0]);
    }
}

