/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.io.Serializable;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.externalizer.DefaultExternalizer;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedBean;
import org.granite.tide.cdi.CDIServiceContext;
import org.granite.tide.cdi.ScopedContextResult;
import org.granite.tide.cdi.TideBean;
import org.granite.tide.cdi.TideInstrumentedBeans;

@TideBean
@ExternalizedBean(type=DefaultExternalizer.class)
@Interceptor
public class TideBeanInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TideBeanInterceptor.class);
    @Inject
    private CDIServiceContext tideContext;
    @Inject
    private TideInstrumentedBeans instrumentedBeans;

    @AroundInvoke
    public Object doAround(InvocationContext invocation) throws Exception {
        Object result = invocation.proceed();
        Bean<?> bean = this.instrumentedBeans.getBean(invocation.getTarget().getClass());
        if (bean == null) {
            log.warn("Instrumented Bean not found for class " + invocation.getTarget().getClass(), new Object[0]);
        } else {
            String componentName = bean.getName();
            ScopedContextResult scr = new ScopedContextResult(componentName, null, invocation.getTarget());
            scr.setComponentClassName(bean.getBeanClass().getName());
            this.tideContext.addResultEval(scr);
        }
        return result;
    }
}

