/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Instance;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.granite.logging.Logger;
import org.granite.tide.cdi.TideDataPublishingEvent;
import org.granite.tide.data.DataContext;
import org.granite.tide.data.DataEnabled;

public class TideDataPublishingOnSuccessHandler {
    private static final Logger log = Logger.getLogger(TideDataPublishingOnSuccessHandler.class);

    public void doPublish(@Observes(during=TransactionPhase.BEFORE_COMPLETION) TideDataPublishingEvent event, Instance<UserTransaction> uts) {
        if (uts.isUnsatisfied() || uts.isAmbiguous()) {
            return;
        }
        UserTransaction ut = (UserTransaction)uts.get();
        try {
            if (ut.getStatus() != 1 && ut.getStatus() != 9 && ut.getStatus() != 9) {
                DataContext.publish((DataEnabled.PublishMode)DataEnabled.PublishMode.ON_COMMIT);
            }
        }
        catch (SystemException e) {
            log.warn((Throwable)e, "Could not get the current status of the transaction ???", new Object[0]);
        }
        if (event.getInitContext()) {
            DataContext.remove();
        }
    }
}

