/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.granite.gravity.Gravity;
import org.granite.tide.cdi.TideDataPublishingEvent;
import org.granite.tide.data.DataContext;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.data.DataTopicParams;
import org.granite.tide.data.DataUpdatePostprocessor;

@DataEnabled(topic="", params=DataTopicParams.class, publish=DataEnabled.PublishMode.MANUAL, useInterceptor=true)
@Interceptor
public class TideDataPublishingInterceptor {
    @Inject
    private Gravity gravity;
    @Inject
    private Instance<DataUpdatePostprocessor> dataUpdatePostprocessor;
    @Inject
    private Event<TideDataPublishingEvent> dataPublishingEvent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object processPublishData(InvocationContext invocationContext) throws Throwable {
        DataEnabled dataEnabled = invocationContext.getMethod().getDeclaringClass().getAnnotation(DataEnabled.class);
        if (dataEnabled == null || !dataEnabled.useInterceptor()) {
            return invocationContext.proceed();
        }
        boolean shouldRemoveContextAtEnd = DataContext.get() == null;
        boolean shouldInitContext = shouldRemoveContextAtEnd || DataContext.isNull();
        boolean onCommit = false;
        if (shouldInitContext) {
            DataContext.init((Gravity)this.gravity, (String)dataEnabled.topic(), (Class)dataEnabled.params(), (DataEnabled.PublishMode)dataEnabled.publish());
            if (!this.dataUpdatePostprocessor.isUnsatisfied()) {
                DataContext.get().setDataUpdatePostprocessor((DataUpdatePostprocessor)this.dataUpdatePostprocessor.get());
            }
        }
        DataContext.observe();
        try {
            if (dataEnabled.publish().equals((Object)DataEnabled.PublishMode.ON_COMMIT)) {
                this.dataPublishingEvent.fire((Object)new TideDataPublishingEvent(shouldRemoveContextAtEnd));
                onCommit = true;
            }
            Object ret = invocationContext.proceed();
            DataContext.publish((DataEnabled.PublishMode)DataEnabled.PublishMode.ON_SUCCESS);
            Object object = ret;
            return object;
        }
        finally {
            if (shouldRemoveContextAtEnd && !onCommit) {
                DataContext.remove();
            }
        }
    }
}

