/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import flex.messaging.messages.RemotingMessage;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.granite.cdi.CDIUtils;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Destination;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.tide.cdi.CDIServiceContext;
import org.granite.tide.cdi.CDIServiceInvoker;
import org.granite.tide.cdi.PersistenceConfiguration;
import org.granite.tide.data.PersistenceExceptionConverter;
import org.granite.util.XMap;

public class CDIServiceFactory
extends ServiceFactory {
    private static final Logger log = Logger.getLogger(CDIServiceFactory.class);
    public static final String ENTITY_MANAGER_FACTORY_JNDI_NAME = "entity-manager-factory-jndi-name";
    public static final String ENTITY_MANAGER_JNDI_NAME = "entity-manager-jndi-name";
    private BeanManager manager;

    public BeanManager getManager() {
        return this.manager;
    }

    public void configure(XMap properties) throws ServiceException {
        block7: {
            String sServiceExceptionHandler = properties.get("service-exception-handler");
            if (sServiceExceptionHandler == null) {
                XMap props = new XMap(properties);
                props.put("service-exception-handler", "org.granite.messaging.service.ExtendedServiceExceptionHandler");
                super.configure(props);
            } else {
                super.configure(properties);
            }
            GraniteContext graniteContext = GraniteContext.getCurrentInstance();
            try {
                ((GraniteConfig)graniteContext.getGraniteConfig()).registerExceptionConverter(PersistenceExceptionConverter.class);
            }
            catch (Throwable t) {
                log.info(t, "JPA exception converter not registered (JPA not found on classpath)", new Object[0]);
            }
            try {
                this.manager = CDIUtils.lookupBeanManager(((ServletGraniteContext)graniteContext).getServletContext());
            }
            catch (Exception e) {
                log.warn("Unable to find the CDI Manager in JNDI, lookup in ServletContext", new Object[0]);
                this.manager = (BeanManager)((HttpGraniteContext)graniteContext).getServletContext().getAttribute("javax.enterprise.inject.spi.BeanManager");
                if (this.manager != null) break block7;
                ServiceException se = new ServiceException(e.getMessage());
                throw se;
            }
        }
        Set cc = this.manager.getBeans(CDIServiceContext.class, new Annotation[0]);
        if (cc.size() != 1) {
            String msg = cc.isEmpty() ? "Unable to find the CDIServiceContext bean" : "More than one CDIServiceContext bean found";
            log.error(msg, new Object[0]);
            ServiceException e = new ServiceException(msg);
            throw e;
        }
    }

    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        ServicesConfig servicesConfig = (ServicesConfig)GraniteContext.getCurrentInstance().getServicesConfig();
        Destination destination = servicesConfig.findDestinationById(messageType, destinationId);
        if (destination == null) {
            throw new ServiceException("No matching destination: " + destinationId);
        }
        if (!destination.getProperties().containsKey("validator-class-name")) {
            destination.getProperties().put("validator-class-name", "org.granite.tide.validation.BeanValidation");
        }
        Bean pcBean = (Bean)this.manager.getBeans(PersistenceConfiguration.class, new Annotation[0]).iterator().next();
        PersistenceConfiguration persistenceConfiguration = (PersistenceConfiguration)this.manager.getReference(pcBean, PersistenceConfiguration.class, this.manager.createCreationalContext((Contextual)pcBean));
        if (destination.getProperties().containsKey(ENTITY_MANAGER_FACTORY_JNDI_NAME)) {
            persistenceConfiguration.setEntityManagerFactoryJndiName(destination.getProperties().get(ENTITY_MANAGER_FACTORY_JNDI_NAME));
        } else if (destination.getProperties().containsKey(ENTITY_MANAGER_JNDI_NAME)) {
            persistenceConfiguration.setEntityManagerJndiName(destination.getProperties().get(ENTITY_MANAGER_JNDI_NAME));
        }
        CDIServiceInvoker invoker = new CDIServiceInvoker(destination, this);
        return invoker;
    }
}

