/*
 * Decompiled with CFR 0.152.
 */
package org.granite.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.granite.context.GraniteContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.gravity.GravityProxy;
import org.granite.messaging.webapp.ServletGraniteContext;

@ApplicationScoped
public class GravityFactory {
    private Gravity gravity;
    private GravityProxy gravityProxy = new CDIGravityProxy();
    @Inject
    Instance<ServletContext> servletContextInstance;
    private static final AnnotationLiteral<Default> DEFAULT_LITERAL = new AnnotationLiteral<Default>(){};

    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    @Produces
    public Gravity getGravity() {
        return this.gravityProxy;
    }

    private class CDIGravityProxy
    extends GravityProxy {
        private CDIGravityProxy() {
        }

        protected Gravity getGravity() {
            GraniteContext graniteContext;
            if (GravityFactory.this.gravity != null) {
                return GravityFactory.this.gravity;
            }
            ServletContext servletContext = null;
            if (!GravityFactory.this.servletContextInstance.isUnsatisfied()) {
                servletContext = (ServletContext)GravityFactory.this.servletContextInstance.select(new Annotation[]{DEFAULT_LITERAL}).get();
            }
            if (servletContext == null && (graniteContext = GraniteContext.getCurrentInstance()) != null && graniteContext instanceof ServletGraniteContext) {
                servletContext = ((ServletGraniteContext)graniteContext).getServletContext();
            }
            return servletContext != null ? GravityManager.getGravity(servletContext) : null;
        }
    }
}

