/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.ejb;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.granite.logging.Logger;
import org.granite.scan.ScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.tide.util.Observer;

public class EjbScannedItemHandler
implements ScannedItemHandler {
    private static final Logger log = Logger.getLogger(EjbScannedItemHandler.class);
    private static final EjbScannedItemHandler instance = new EjbScannedItemHandler();
    private final Map<Class<?>, Class<?>> scannedClasses = new HashMap();
    private final Map<String, Set<Method>> observers = new HashMap<String, Set<Method>>();

    public static EjbScannedItemHandler instance() {
        return instance;
    }

    static EjbScannedItemHandler instance(boolean reset) {
        EjbScannedItemHandler.instance.scannedClasses.clear();
        EjbScannedItemHandler.instance.observers.clear();
        return instance;
    }

    private EjbScannedItemHandler() {
    }

    public boolean handleMarkerItem(ScannedItem item) {
        return false;
    }

    public void handleScannedItem(ScannedItem item) {
        if ("class".equals(item.getExtension()) && item.getName().indexOf(36) == -1) {
            try {
                Class clazz = item.loadAsClass();
                if (clazz.isAnnotationPresent(Stateless.class) || clazz.isAnnotationPresent(Stateful.class)) {
                    this.scannedClasses.put(clazz, clazz);
                    if (clazz.isAnnotationPresent(Local.class)) {
                        for (Class clazz2 : clazz.getAnnotation(Local.class).value()) {
                            this.scannedClasses.put(clazz2, clazz);
                        }
                    }
                    if (clazz.isAnnotationPresent(Remote.class)) {
                        for (GenericDeclaration genericDeclaration : clazz.getAnnotation(Remote.class).value()) {
                            this.scannedClasses.put((Class<?>)genericDeclaration, clazz);
                        }
                    }
                    for (Class clazz3 : clazz.getInterfaces()) {
                        if (clazz3.isAnnotationPresent(Local.class)) {
                            this.scannedClasses.put(clazz3, clazz);
                        }
                        if (!clazz3.isAnnotationPresent(Remote.class)) continue;
                        this.scannedClasses.put(clazz3, clazz);
                    }
                    for (GenericDeclaration genericDeclaration : clazz.getMethods()) {
                        if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(Observer.class)) continue;
                        Observer o = ((Method)genericDeclaration).getAnnotation(Observer.class);
                        Set<Method> methods = this.observers.get(o.value());
                        if (methods == null) {
                            methods = new HashSet<Method>();
                            this.observers.put(o.value(), methods);
                        }
                        methods.add((Method)genericDeclaration);
                    }
                }
            }
            catch (Exception e) {
                log.debug((Throwable)e, "Could not introspect scanned item: %s", new Object[]{item});
            }
        }
    }

    public Map<Class<?>, Class<?>> getScannedClasses() {
        return this.scannedClasses;
    }

    public Map<String, Set<Method>> getObservers() {
        return this.observers;
    }
}

