/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.ejb;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import org.granite.config.ConfigProvider;
import org.granite.ejb.Gravity;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceFactory;
import org.granite.tide.ejb.EjbIdentity;
import org.granite.tide.ejb.EjbServiceFactory;

public class EjbConfigProvider
implements ConfigProvider {
    private static final Logger log = Logger.getLogger(EjbConfigProvider.class);
    private ServletContext servletContext;

    public EjbConfigProvider(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Boolean useTide() {
        return true;
    }

    public String getType() {
        return "server";
    }

    public Class<? extends ServiceFactory> getFactoryClass() {
        return EjbServiceFactory.class;
    }

    public <T> T findInstance(Class<T> type) {
        return null;
    }

    public <T> Set<T> findInstances(Class<T> type) {
        return Collections.emptySet();
    }

    public Class<?>[] getTideInterfaces() {
        return new Class[]{EjbIdentity.class};
    }

    public Class<? extends Annotation>[] getTideAnnotations() {
        return new Class[0];
    }

    public void initGravity(org.granite.gravity.Gravity gravity) {
        try {
            InitialContext ic = new InitialContext();
            Gravity gravityEJB = (Gravity)ic.lookup("java:global" + this.servletContext.getContextPath() + "/org.granite.ejb.Gravity");
            gravityEJB.setGravity(gravity);
            log.info("Registered Gravity EJB", new Object[0]);
        }
        catch (Exception e) {
            log.debug((Throwable)e, "Gravity EJB not found", new Object[0]);
        }
    }
}

