/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.glassfish;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.context.SimpleGraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.glassfish.GlassFishWebSocketChannelFactory;
import org.granite.logging.Logger;
import org.granite.messaging.jmf.JMFDeserializer;
import org.granite.messaging.jmf.JMFSerializer;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ContentType;

public class GlassFishWebSocketChannel
extends AbstractChannel
implements WebSocketListener {
    private static final Logger log = Logger.getLogger(GlassFishWebSocketChannel.class);
    private WebSocket websocket;
    private HttpSession session;
    private Message connectAckMessage;
    private ContentType contentType;

    public GlassFishWebSocketChannel(Gravity gravity, String id, GlassFishWebSocketChannelFactory factory, String clientType) {
        super(gravity, id, (ChannelFactory)factory, clientType);
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void setConnectAckMessage(Message ackMessage) {
        this.connectAckMessage = ackMessage;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setWebSocket(WebSocket websocket) {
        this.websocket = websocket;
        this.websocket.add((WebSocketListener)this);
        if (this.connectAckMessage == null) {
            return;
        }
        try {
            byte[] resultData = this.serialize(this.getGravity(), new Message[]{this.connectAckMessage});
            websocket.send(resultData);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not send connect acknowledge", e);
        }
        this.connectAckMessage = null;
    }

    public void onConnect(WebSocket websocket) {
    }

    public void onClose(WebSocket websocket, DataFrame frame) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(WebSocket websocket, byte[] data) {
        try {
            this.initializeRequest();
            Message[] messages = this.deserialize(this.getGravity(), data);
            log.debug(">> [AMF3 REQUESTS] %s", new Object[]{messages});
            Message[] responses = null;
            boolean accessed = false;
            for (int i = 0; i < messages.length; ++i) {
                Message message = messages[i];
                Message response = this.getGravity().handleMessage(this.getFactory(), message);
                String channelId = (String)message.getClientId();
                if (!accessed) {
                    accessed = this.getGravity().access(channelId);
                }
                if (responses == null) {
                    responses = new Message[messages.length];
                }
                responses[i] = response;
            }
            log.debug("<< [AMF3 RESPONSES] %s", new Object[]{responses});
            byte[] resultData = this.serialize(this.getGravity(), responses);
            websocket.send(resultData);
        }
        catch (ClassNotFoundException e) {
            log.error((Throwable)e, "Could not handle incoming message data", new Object[0]);
        }
        catch (IOException e) {
            log.error((Throwable)e, "Could not handle incoming message data", new Object[0]);
        }
        finally {
            GlassFishWebSocketChannel.cleanupRequest();
        }
    }

    private Gravity initializeRequest() {
        if (this.session != null) {
            ServletGraniteContext.createThreadInstance((GraniteConfig)this.gravity.getGraniteConfig(), (ServicesConfig)this.gravity.getServicesConfig(), (ServletContext)this.session.getServletContext(), (HttpSession)this.session, (String)this.clientType);
        } else {
            SimpleGraniteContext.createThreadInstance((GraniteConfig)this.gravity.getGraniteConfig(), (ServicesConfig)this.gravity.getServicesConfig(), (String)this.sessionId, new HashMap(), (String)this.clientType);
        }
        return this.gravity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message[] deserialize(Gravity gravity, byte[] data) throws ClassNotFoundException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        try {
            Message[] messages = null;
            if (ContentType.JMF_AMF.equals((Object)this.contentType)) {
                JMFDeserializer deserializer = new JMFDeserializer((InputStream)is, gravity.getSharedContext());
                messages = (Message[])deserializer.readObject();
            } else {
                ObjectInput amf3Deserializer = gravity.getGraniteConfig().newAMF3Deserializer((InputStream)is);
                Object[] objects = (Object[])amf3Deserializer.readObject();
                messages = new Message[objects.length];
                System.arraycopy(objects, 0, messages, 0, objects.length);
            }
            Message[] messageArray = messages;
            return messageArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serialize(Gravity gravity, Message[] messages) throws IOException {
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream(200 * messages.length);
            if (ContentType.JMF_AMF.equals((Object)this.contentType)) {
                JMFSerializer serializer = new JMFSerializer((OutputStream)os, gravity.getSharedContext());
                serializer.writeObject((Object)messages);
            } else {
                ObjectOutput amf3Serializer = gravity.getGraniteConfig().newAMF3Serializer((OutputStream)os);
                amf3Serializer.writeObject(messages);
                os.flush();
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private static void cleanupRequest() {
        GraniteContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runReceived(AsyncHttpContext asyncHttpContext) {
        LinkedList messages = null;
        ByteArrayOutputStream os = null;
        try {
            this.receivedQueueLock.lock();
            try {
                if (this.receivedQueue.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                messages = this.receivedQueue;
                this.receivedQueue = new LinkedList();
            }
            finally {
                this.receivedQueueLock.unlock();
            }
            if (this.websocket == null || !this.websocket.isConnected()) {
                boolean bl = false;
                return bl;
            }
            AsyncMessage[] messagesArray = new AsyncMessage[messages.size()];
            int i = 0;
            for (AsyncMessage message : messages) {
                messagesArray[i++] = message;
            }
            Gravity gravity = this.getGravity();
            SimpleGraniteContext.createThreadInstance((GraniteConfig)gravity.getGraniteConfig(), (ServicesConfig)gravity.getServicesConfig(), (String)this.sessionId, new HashMap(), (String)this.clientType);
            log.debug("<< [MESSAGES for channel=%s] %s", new Object[]{this, messagesArray});
            byte[] msg = this.serialize(gravity, (Message[])messagesArray);
            if (msg.length > 16000) {
                int count = msg.length / 2000;
                int chunkSize = Math.max(1, messagesArray.length / count);
                for (int index = 0; index < messagesArray.length; index += chunkSize) {
                    AsyncMessage[] chunk = Arrays.copyOfRange(messagesArray, index, Math.min(messagesArray.length, index + chunkSize));
                    msg = this.serialize(gravity, (Message[])chunk);
                    log.debug("Send binary message: %d msgs (%d bytes)", new Object[]{chunk.length, msg.length});
                    this.websocket.send(msg);
                }
            } else {
                this.websocket.send(msg);
                log.debug("Send binary message: %d msgs (%d bytes)", new Object[]{messagesArray.length, msg.length});
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Could not send messages to channel: %s (retrying later)", new Object[]{this});
            GravityConfig gravityConfig = this.getGravity().getGravityConfig();
            if (gravityConfig.isRetryOnError()) {
                this.receivedQueueLock.lock();
                try {
                    if (this.receivedQueue.size() + messages.size() > gravityConfig.getMaxMessagesQueuedPerChannel()) {
                        log.warn("Channel %s has reached its maximum queue capacity %s (throwing %s messages)", new Object[]{this, gravityConfig.getMaxMessagesQueuedPerChannel(), messages.size()});
                    } else {
                        this.receivedQueue.addAll(0, messages);
                    }
                }
                finally {
                    this.receivedQueueLock.unlock();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {}
            }
            try {
                GraniteContext.release();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            this.close();
        }
    }

    public void close() {
        if (this.websocket != null) {
            this.websocket.close(1000, "Channel closed");
            this.websocket = null;
        }
    }

    protected boolean hasAsyncHttpContext() {
        return true;
    }

    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
    }

    protected AsyncHttpContext acquireAsyncHttpContext() {
        return null;
    }

    public void onFragment(WebSocket arg0, String arg1, boolean arg2) {
    }

    public void onFragment(WebSocket arg0, byte[] arg1, boolean arg2) {
    }

    public void onMessage(WebSocket arg0, String arg1) {
    }

    public void onPing(WebSocket arg0, byte[] arg1) {
    }

    public void onPong(WebSocket arg0, byte[] arg1) {
    }
}

