/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.glassfish;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.glassfish.GlassFishWebSocketChannel;
import org.granite.gravity.glassfish.GlassFishWebSocketChannelFactory;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ContentType;

public class GlassFishWebSocketApplication
extends WebSocketApplication {
    private static final Logger log = Logger.getLogger(GlassFishWebSocketApplication.class);
    private final ServletContext servletContext;
    private final GravityInternal gravity;
    private final Pattern mapping;
    private final String servletName;
    private String protocol;

    public GlassFishWebSocketApplication(ServletContext servletContext, GravityInternal gravity, String mapping, String servletName) {
        this.servletContext = servletContext;
        this.gravity = gravity;
        this.mapping = Pattern.compile(".*" + mapping.replace("*", ".*") + "$");
        this.servletName = servletName;
    }

    public List<String> getSupportedProtocols(List<String> subProtocols) {
        for (String subProtocol : subProtocols) {
            if (!subProtocol.startsWith("org.granite.gravity")) continue;
            this.protocol = subProtocol;
            return Collections.singletonList(subProtocol);
        }
        return Collections.emptyList();
    }

    public boolean isApplicationRequest(Request request) {
        String uri = request.requestURI().toString();
        return this.mapping.matcher(uri).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnect(WebSocket websocket) {
        if (!(websocket instanceof DefaultWebSocket)) {
            throw new IllegalStateException("Only DefaultWebSocket supported");
        }
        GlassFishWebSocketChannelFactory channelFactory = new GlassFishWebSocketChannelFactory(this.gravity);
        HttpServletRequest request = ((DefaultWebSocket)websocket).getRequest();
        try {
            ContentType contentType;
            String connectMessageId = request.getHeader("connectId") != null ? request.getHeader("connectId") : request.getParameter("connectId");
            String clientId = request.getHeader("GDSClientId") != null ? request.getHeader("GDSClientId") : request.getParameter("GDSClientId");
            String clientType = request.getHeader("GDSClientType") != null ? request.getHeader("GDSClientType") : request.getParameter("GDSClientType");
            String sessionId = null;
            HttpSession session = request.getSession("true".equals(this.servletContext.getInitParameter("org.granite.gravity.websocket.forceCreateSession")));
            if (session != null) {
                ServletGraniteContext.createThreadInstance((GraniteConfig)this.gravity.getGraniteConfig(), (ServicesConfig)this.gravity.getServicesConfig(), (ServletContext)this.servletContext, (HttpSession)session, (String)clientType);
                sessionId = session.getId();
            } else if (request.getCookies() != null) {
                for (int i = 0; i < request.getCookies().length; ++i) {
                    if (!"JSESSIONID".equals(request.getCookies()[i].getName())) continue;
                    sessionId = request.getCookies()[i].getValue();
                    break;
                }
                ServletGraniteContext.createThreadInstance((GraniteConfig)this.gravity.getGraniteConfig(), (ServicesConfig)this.gravity.getServicesConfig(), (ServletContext)this.servletContext, (String)sessionId, (String)clientType);
            } else {
                ServletGraniteContext.createThreadInstance((GraniteConfig)this.gravity.getGraniteConfig(), (ServicesConfig)this.gravity.getServicesConfig(), (ServletContext)this.servletContext, (String)null, (String)clientType);
            }
            log.info("WebSocket connection started %s clientId %s sessionId %s", new Object[]{this.protocol, clientId, sessionId});
            if (this.gravity.getGraniteConfig().getSecurityService() != null) {
                this.gravity.getGraniteConfig().getSecurityService().prelogin(session, (Object)request, this.servletName);
            }
            CommandMessage pingMessage = new CommandMessage();
            pingMessage.setMessageId(connectMessageId != null ? connectMessageId : "OPEN_CONNECTION");
            pingMessage.setOperation(5);
            if (clientId != null) {
                pingMessage.setClientId((Object)clientId);
            }
            Message ackMessage = this.gravity.handleMessage((ChannelFactory)channelFactory, (Message)pingMessage);
            if (sessionId != null) {
                ackMessage.setHeader("JSESSIONID", (Object)sessionId);
            }
            GlassFishWebSocketChannel channel = (GlassFishWebSocketChannel)this.gravity.getChannel((ChannelFactory)channelFactory, (String)ackMessage.getClientId());
            channel.setSession(session);
            String ctype = request.getContentType();
            if (ctype == null && this.protocol.length() > "org.granite.gravity".length()) {
                ctype = "application/x-" + this.protocol.substring("org.granite.gravity.".length());
            }
            if ((contentType = ContentType.forMimeType((String)ctype)) == null) {
                log.warn("No (or unsupported) content type in request: %s", new Object[]{request.getContentType()});
                contentType = ContentType.AMF;
            }
            channel.setContentType(contentType);
            if (!ackMessage.getClientId().equals(clientId)) {
                channel.setConnectAckMessage(ackMessage);
            }
            channel.setWebSocket(websocket);
        }
        finally {
            GraniteContext.release();
        }
    }
}

