/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import com.sun.web.security.RealmAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Engine;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.core.StandardContext;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.ServletGraniteContext;

public class GlassFishV3SecurityService
extends AbstractSecurityService {
    private static final Logger log = Logger.getLogger(GlassFishV3SecurityService.class);
    private static Method authenticate = null;
    private final Field requestField;
    private Engine engine = null;

    private static Principal authenticate(Realm realm, String username, String password) {
        try {
            if (authenticate.getParameterTypes()[1].equals(String.class)) {
                return (Principal)authenticate.invoke((Object)realm, username, password);
            }
            return (Principal)authenticate.invoke((Object)realm, username, password.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GlassFishV3SecurityService() {
        try {
            this.requestField = RequestFacade.class.getDeclaredField("request");
            this.requestField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get 'request' field in GlassFish V3 RequestFacade", e);
        }
    }

    protected Field getRequestField() {
        return this.requestField;
    }

    protected Engine getEngine() {
        return this.engine;
    }

    public void configure(Map<String, String> params) {
        String serviceId = params.get("service");
        Server server = ServerFactory.getServer();
        if (server == null) {
            throw new NullPointerException("Could not get GlassFish V3 server");
        }
        Service service = null;
        if (serviceId != null) {
            service = server.findService(serviceId);
        } else {
            Service[] services = server.findServices();
            if (services != null && services.length > 0) {
                service = services[0];
            }
        }
        if (service == null) {
            throw new NullPointerException("Could not find GlassFish V3 service for: " + (serviceId != null ? serviceId : "(default)"));
        }
        this.engine = (Engine)service.getContainer();
        if (this.engine == null) {
            throw new NullPointerException("Could not find GlassFish V3 container for: " + (serviceId != null ? serviceId : "(default)"));
        }
    }

    public void prelogin(HttpSession session, Object httpRequest, String servletName) {
        Field f;
        if (session == null) {
            return;
        }
        if (session.getAttribute(SecurityService.AuthenticationContext.class.getName()) instanceof GlassFishV3AuthenticationContext) {
            return;
        }
        HttpServletRequest request = null;
        RealmAdapter realm = null;
        if (httpRequest.getClass().getName().equals("com.sun.grizzly.websockets.ServerNetworkHandler$WSServletRequestImpl")) {
            f = null;
            try {
                f = httpRequest.getClass().getDeclaredField("glassfishSupport");
                f.setAccessible(true);
                Object gfs = f.get(httpRequest);
                f = gfs.getClass().getDeclaredField("context");
                f.setAccessible(true);
                Object ctx = f.get(gfs);
                f = ctx.getClass().getDeclaredField("context");
                f.setAccessible(true);
                StandardContext sc = (StandardContext)f.get(ctx);
                realm = (RealmAdapter)sc.getRealm();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get internal glassfish v3 request", e);
            }
        }
        if (httpRequest instanceof HttpServletRequest) {
            request = (HttpServletRequest)httpRequest;
        } else if (httpRequest.getClass().getName().equals("org.glassfish.tyrus.core.RequestContext")) {
            f = null;
            try {
                f = httpRequest.getClass().getDeclaredField("isUserInRoleDelegate");
                f.setAccessible(true);
                Object delegate = f.get(httpRequest);
                f = delegate.getClass().getDeclaredField("val$httpServletRequest");
                f.setAccessible(true);
                request = (HttpServletRequest)f.get(delegate);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get internal glassfish v3 / tyrus request", e);
            }
        }
        servletName = this.getRequest(request).getWrapper().getServletName();
        realm = this.getRealm(request);
        GlassFishV3AuthenticationContext authorizationContext = new GlassFishV3AuthenticationContext(servletName, realm);
        session.setAttribute(SecurityService.AuthenticationContext.class.getName(), (Object)authorizationContext);
    }

    public Principal login(Object credentials, String charset) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials, charset);
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        Principal principal = null;
        Request request = null;
        if (graniteContext instanceof HttpGraniteContext) {
            HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
            HttpServletRequest httpRequest = context.getRequest();
            request = this.getRequest(httpRequest);
            RealmAdapter realm = (RealmAdapter)request.getContext().getRealm();
            GlassFishV3AuthenticationContext authenticationContext = new GlassFishV3AuthenticationContext(request.getWrapper().getServletName(), realm);
            principal = authenticationContext.authenticate(decoded[0], decoded[1]);
            if (principal != null) {
                graniteContext.getSession().setAttribute(SecurityService.AuthenticationContext.class.getName(), (Object)authenticationContext);
            }
        } else {
            SecurityService.AuthenticationContext authenticationContext = (SecurityService.AuthenticationContext)graniteContext.getSession().getAttribute(SecurityService.AuthenticationContext.class.getName());
            if (authenticationContext != null) {
                principal = authenticationContext.authenticate(decoded[0], decoded[1]);
            }
        }
        if (principal == null) {
            throw SecurityServiceException.newInvalidCredentialsException((String)"Wrong username or password");
        }
        if (graniteContext instanceof HttpGraniteContext) {
            request.setAuthType("granite-security");
            request.setUserPrincipal(principal);
            Session session = request.getSessionInternal();
            session.setAuthType("granite-security");
            session.setPrincipal(principal);
            session.setNote("org.apache.catalina.session.USERNAME", (Object)decoded[0]);
            session.setNote("org.apache.catalina.session.PASSWORD", (Object)decoded[1]);
        }
        this.endLogin(credentials, charset);
        return principal;
    }

    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = null;
        SecurityService.AuthenticationContext authenticationContext = null;
        Principal principal = null;
        if (graniteContext instanceof HttpGraniteContext) {
            httpRequest = graniteContext.getRequest();
            Request request = this.getRequest(httpRequest);
            Session session = request.getSessionInternal(false);
            if (session != null) {
                request.setAuthType(session.getAuthType());
                principal = session.getPrincipal();
                if (principal == null && this.tryRelogin()) {
                    principal = session.getPrincipal();
                }
            }
            request.setUserPrincipal(principal);
        } else {
            HttpSession session = graniteContext.getSession(false);
            if (session != null && (authenticationContext = (SecurityService.AuthenticationContext)session.getAttribute(SecurityService.AuthenticationContext.class.getName())) != null) {
                principal = authenticationContext.getPrincipal();
            }
        }
        if (context.getDestination().isSecured()) {
            if (principal == null) {
                HttpSession httpSession;
                if (!(httpRequest == null || httpRequest.getRequestedSessionId() == null || (httpSession = httpRequest.getSession(false)) != null && httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                    throw SecurityServiceException.newSessionExpiredException((String)"Session expired");
                }
                throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
            }
            if (httpRequest == null && authenticationContext == null) {
                throw SecurityServiceException.newNotLoggedInException((String)"No authorization context");
            }
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (httpRequest != null && httpRequest.isUserInRole(role)) {
                    accessDenied = false;
                    break;
                }
                if (authenticationContext == null || !authenticationContext.isUserInRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException((String)"User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (!(t instanceof SecurityException) && !"javax.ejb.EJBAccessException".equals(t.getClass().getName())) continue;
                throw SecurityServiceException.newAccessDeniedException((String)t.getMessage());
            }
            throw e;
        }
    }

    public void logout() throws SecurityServiceException {
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        if (graniteContext instanceof HttpGraniteContext) {
            Session session = this.getSession(graniteContext.getRequest(), false);
            if (session != null && session.getPrincipal() != null) {
                session.setAuthType(null);
                session.setPrincipal(null);
                session.removeNote("org.apache.catalina.session.USERNAME");
                session.removeNote("org.apache.catalina.session.PASSWORD");
                this.endLogout();
                session.expire();
            }
        } else {
            HttpSession session = graniteContext.getSession();
            if (session != null) {
                session.removeAttribute(SecurityService.AuthenticationContext.class.getName());
                this.endLogout();
                session.invalidate();
            }
        }
    }

    protected Session getSession(HttpServletRequest httpRequest, boolean create) {
        Request request = this.getRequest(httpRequest);
        return request.getSessionInternal(create);
    }

    protected Request getRequest(HttpServletRequest request) {
        while (request instanceof HttpServletRequestWrapper) {
            request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
        }
        try {
            return (Request)this.requestField.get(request);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get GlassFish V3 request", e);
        }
    }

    protected RealmAdapter getRealm(HttpServletRequest request) {
        Request creq = this.getRequest(request);
        return (RealmAdapter)creq.getContext().getRealm();
    }

    static {
        try {
            authenticate = Realm.class.getMethod("authenticate", String.class, String.class);
            log.info("Detected GlassFish v3.0 authentication", new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        if (authenticate == null) {
            try {
                authenticate = Realm.class.getMethod("authenticate", String.class, char[].class);
                log.info("Detected GlassFish v3.1+ authentication", new Object[0]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (authenticate == null) {
            throw new ExceptionInInitializerError("Could not find any supported Realm.authenticate method");
        }
    }

    public static class GlassFishV3AuthenticationContext
    implements SecurityService.AuthenticationContext {
        private static final long serialVersionUID = 1L;
        private final String securityServletName;
        private final transient RealmAdapter realm;
        private transient Principal principal;

        public GlassFishV3AuthenticationContext(String securityServletName, RealmAdapter realm) {
            this.securityServletName = securityServletName;
            this.realm = realm;
        }

        public Principal authenticate(String username, String password) {
            if (this.realm == null) {
                throw SecurityServiceException.newAuthenticationFailedException((String)"Invalid authentication");
            }
            this.principal = GlassFishV3SecurityService.authenticate((Realm)this.realm, username, password);
            return this.principal;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return this.realm.hasRole(this.securityServletName, this.principal, role);
        }

        public void logout() {
            this.realm.logout();
        }
    }
}

