/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.glassfish;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.glassfish.GlassFishWebSocketChannelFactory;
import org.granite.gravity.websocket.AbstractWebSocketChannel;
import org.granite.logging.Logger;

public class GlassFishWebSocketChannel
extends AbstractWebSocketChannel
implements WebSocketListener {
    private static final Logger log = Logger.getLogger(GlassFishWebSocketChannel.class);
    private WebSocket websocket;

    public GlassFishWebSocketChannel(GravityInternal gravity, String id, GlassFishWebSocketChannelFactory factory, String clientType) {
        super(gravity, id, (ChannelFactory)factory, clientType);
    }

    public void setWebSocket(WebSocket websocket) {
        this.websocket = websocket;
        this.websocket.add((WebSocketListener)this);
        this.connect();
    }

    public void onConnect(WebSocket websocket) {
        log.debug("Channel %s onConnect", new Object[]{this.getId()});
    }

    public void onClose(WebSocket websocket, DataFrame frame) {
        log.debug("Channel %s onClose", new Object[]{this.getId()});
        this.websocket = null;
    }

    public void onMessage(WebSocket websocket, byte[] data) {
        super.receiveBytes(data, 0, data.length);
    }

    public void onMessage(WebSocket websocket, String message) {
        log.warn("Channel %s unsupported text message", new Object[]{this.getId()});
    }

    public void onFragment(WebSocket websocket, String message, boolean isLast) {
        log.warn("Channel %s unsupported onFragment text message", new Object[]{this.getId()});
    }

    public void onFragment(WebSocket websocket, byte[] data, boolean isLast) {
        log.warn("Channel %s unsupported onFragment binary message", new Object[]{this.getId()});
    }

    public void onPing(WebSocket websocket, byte[] data) {
        log.warn("Channel %s unsupported onPing message", new Object[]{this.getId()});
    }

    public void onPong(WebSocket websocket, byte[] data) {
        log.warn("Channel %s unsupported onPong message", new Object[]{this.getId()});
    }

    protected boolean isConnected() {
        return this.websocket != null && this.websocket.isConnected();
    }

    protected void sendBytes(byte[] msg) {
        this.websocket.send(msg);
    }

    public void close() {
        if (this.websocket != null) {
            this.websocket.close(1000, "Channel closed");
            this.websocket = null;
        }
    }
}

