/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jbossweb;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.GravityManager;
import org.granite.gravity.jbossweb.AbstractHttpEventServlet;
import org.granite.gravity.jbossweb.ByteArrayCometIO;
import org.granite.gravity.jbossweb.CometIO;
import org.granite.gravity.jbossweb.EventUtil;
import org.granite.gravity.jbossweb.JBossWebChannel;
import org.granite.gravity.jbossweb.JBossWebChannelFactory;
import org.granite.logging.Logger;
import org.granite.util.ContentType;
import org.jboss.servlet.http.HttpEvent;

public class GravityJBossWebServlet
extends AbstractHttpEventServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GravityJBossWebServlet.class);

    @Override
    public CometIO createCometIO() {
        return new ByteArrayCometIO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRequest(HttpEvent event, InputStream content) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        GravityInternal gravity = (GravityInternal)GravityManager.getGravity((ServletContext)this.getServletContext());
        JBossWebChannelFactory channelFactory = new JBossWebChannelFactory(gravity);
        try {
            this.initializeRequest(gravity, request, response);
            Message[] amf3Requests = this.deserialize(gravity, request, content);
            log.debug(">> [AMF3 REQUESTS] %s", new Object[]{amf3Requests});
            Message[] amf3Responses = null;
            boolean accessed = false;
            for (int i = 0; i < amf3Requests.length; ++i) {
                Message amf3Request = amf3Requests[i];
                Message amf3Response = gravity.handleMessage((ChannelFactory)channelFactory, amf3Request);
                String channelId = (String)amf3Request.getClientId();
                if (!accessed) {
                    accessed = gravity.access(channelId);
                }
                if (amf3Response == null) {
                    if (amf3Requests.length > 1) {
                        throw new IllegalArgumentException("Only one request is allowed on tunnel.");
                    }
                    JBossWebChannel channel = (JBossWebChannel)gravity.getChannel((ChannelFactory)channelFactory, channelId);
                    if (channel == null) {
                        throw new NullPointerException("No channel on tunnel connect");
                    }
                    if (channel.runReceived(new AsyncHttpContext(request, response, amf3Request))) {
                        boolean bl = true;
                        return bl;
                    }
                    GravityJBossWebServlet.setConnectMessage((HttpServletRequest)request, (Message)amf3Request);
                    channel.setHttpEvent(event);
                    boolean bl = false;
                    return bl;
                }
                if (amf3Responses == null) {
                    amf3Responses = new Message[amf3Requests.length];
                }
                amf3Responses[i] = amf3Response;
            }
            log.debug("<< [AMF3 RESPONSES] %s", new Object[]{amf3Responses});
            this.serialize(gravity, response, amf3Responses, ContentType.forMimeType((String)request.getContentType()));
        }
        catch (IOException e) {
            log.error((Throwable)e, "Gravity message error", new Object[0]);
            throw e;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Gravity message error", new Object[0]);
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (content != null) {
                    content.close();
                }
            }
            finally {
                this.cleanupRequest(request);
            }
        }
        return true;
    }

    @Override
    public boolean handleEnd(HttpEvent event) throws IOException, ServletException {
        return true;
    }

    @Override
    public boolean handleError(HttpEvent event) throws IOException {
        if (EventUtil.isErrorButNotTimeout(event)) {
            log.error("Got an error event: %s", new Object[]{EventUtil.toString(event)});
        }
        try {
            String channelId;
            JBossWebChannelFactory channelFactory;
            GravityInternal gravity;
            JBossWebChannel channel;
            HttpServletRequest request = event.getHttpServletRequest();
            CommandMessage connect = GravityJBossWebServlet.getConnectMessage((HttpServletRequest)request);
            if (connect != null && (channel = (JBossWebChannel)(gravity = (GravityInternal)GravityManager.getGravity((ServletContext)this.getServletContext())).getChannel((ChannelFactory)(channelFactory = new JBossWebChannelFactory(gravity)), channelId = (String)connect.getClientId())) != null) {
                channel.setHttpEvent(null);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error while processing event: %s", new Object[]{EventUtil.toString(event)});
        }
        return true;
    }
}

