/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty9;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.net.HttpCookie;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.GravityManager;
import org.granite.gravity.jetty9.JettyWebSocketChannel;
import org.granite.gravity.jetty9.JettyWebSocketChannelFactory;
import org.granite.gravity.websocket.WebSocketUtil;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ContentType;

public class JettyWebSocketCreator
implements WebSocketCreator {
    private static final Logger log = Logger.getLogger(JettyWebSocketCreator.class);
    private final ServletContext servletContext;

    public JettyWebSocketCreator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
        String protocol = null;
        for (String p : servletUpgradeRequest.getSubProtocols()) {
            if (!p.startsWith("org.granite.gravity")) continue;
            protocol = p;
            break;
        }
        if (protocol == null) {
            return null;
        }
        GravityInternal gravity = (GravityInternal)GravityManager.getGravity((ServletContext)this.servletContext);
        JettyWebSocketChannelFactory channelFactory = new JettyWebSocketChannelFactory(gravity);
        try {
            String connectMessageId = JettyWebSocketCreator.getHeaderOrParameter(servletUpgradeRequest, "connectId");
            String clientId = JettyWebSocketCreator.getHeaderOrParameter(servletUpgradeRequest, "GDSClientId");
            String clientType = JettyWebSocketCreator.getHeaderOrParameter(servletUpgradeRequest, "GDSClientType");
            String sessionId = null;
            HttpSession session = servletUpgradeRequest.getSession();
            if (session != null) {
                ServletGraniteContext.createThreadInstance((GraniteConfig)gravity.getGraniteConfig(), (ServicesConfig)gravity.getServicesConfig(), (ServletContext)this.servletContext, (HttpSession)session, (String)clientType);
                sessionId = session.getId();
            } else if (servletUpgradeRequest.getCookies() != null) {
                for (int i = 0; i < servletUpgradeRequest.getCookies().size(); ++i) {
                    if (!"JSESSIONID".equals(((HttpCookie)servletUpgradeRequest.getCookies().get(i)).getName())) continue;
                    sessionId = ((HttpCookie)servletUpgradeRequest.getCookies().get(i)).getValue();
                    break;
                }
                ServletGraniteContext.createThreadInstance((GraniteConfig)gravity.getGraniteConfig(), (ServicesConfig)gravity.getServicesConfig(), (ServletContext)this.servletContext, (String)sessionId, (String)clientType);
            } else {
                ServletGraniteContext.createThreadInstance((GraniteConfig)gravity.getGraniteConfig(), (ServicesConfig)gravity.getServicesConfig(), (ServletContext)this.servletContext, (String)null, (String)clientType);
            }
            CommandMessage pingMessage = new CommandMessage();
            pingMessage.setMessageId(connectMessageId != null ? connectMessageId : "OPEN_CONNECTION");
            pingMessage.setOperation(5);
            if (clientId != null) {
                pingMessage.setClientId((Object)clientId);
            }
            Message ackMessage = gravity.handleMessage((ChannelFactory)channelFactory, (Message)pingMessage);
            if (sessionId != null) {
                ackMessage.setHeader("JSESSIONID", (Object)sessionId);
            }
            log.info("WebSocket connection started %s connectId %s clientId %s ackClientId %s sessionId %s", new Object[]{protocol, pingMessage.getMessageId(), clientId, ackMessage.getClientId(), sessionId});
            if (gravity.getGraniteConfig().getSecurityService() != null) {
                gravity.getGraniteConfig().getSecurityService().prelogin(session, (Object)servletUpgradeRequest.getHttpServletRequest(), null);
            }
            JettyWebSocketChannel channel = (JettyWebSocketChannel)gravity.getChannel((ChannelFactory)channelFactory, (String)ackMessage.getClientId());
            channel.setSession(session);
            String ctype = servletUpgradeRequest.getHeader("Content-Type");
            ContentType contentType = WebSocketUtil.getContentType((String)ctype, (String)protocol);
            channel.setContentType(contentType);
            channel.setConnectAckMessage(ackMessage);
            JettyWebSocketChannel jettyWebSocketChannel = channel;
            return jettyWebSocketChannel;
        }
        finally {
            GraniteContext.release();
        }
    }

    private static String getHeaderOrParameter(ServletUpgradeRequest servletUpgradeRequest, String key) {
        String value = servletUpgradeRequest.getHeader(key);
        if (value == null) {
            value = servletUpgradeRequest.getHttpServletRequest().getParameter(key);
        }
        return value;
    }
}

