/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.websocket.servlet.PostUpgradedHttpServletRequest;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.ServletGraniteContext;

public class Jetty9SecurityService
extends AbstractSecurityService {
    private final Field requestField;

    public Jetty9SecurityService() {
        try {
            this.requestField = ServletRequestWrapper.class.getDeclaredField("request");
            this.requestField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get 'request' field in Jetty ServletRequest", e);
        }
    }

    public void configure(Map<String, String> params) {
    }

    public void prelogin(HttpSession session, Object httpRequest, String servletName) {
        if (session == null) {
            return;
        }
        if (session.getAttribute(SecurityService.AuthenticationContext.class.getName()) instanceof Jetty9AuthenticationContext) {
            return;
        }
        Request request = null;
        if (httpRequest.getClass().getName().equals("org.eclipse.jetty.websocket.jsr356.server.JsrHandshakeRequest")) {
            try {
                Field f = httpRequest.getClass().getDeclaredField("request");
                f.setAccessible(true);
                httpRequest = f.get(httpRequest);
                f = httpRequest.getClass().getDeclaredField("req");
                f.setAccessible(true);
                httpRequest = f.get(httpRequest);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not unwrap jetty JSR request", e);
            }
        }
        if (httpRequest instanceof PostUpgradedHttpServletRequest) {
            try {
                request = (Request)this.requestField.get(httpRequest);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get internal jetty request", e);
            }
        } else {
            request = (Request)httpRequest;
        }
        Authentication authentication = request.getAuthentication();
        UserIdentity.Scope scope = request.getUserIdentityScope();
        Jetty9AuthenticationContext authorizationContext = new Jetty9AuthenticationContext(scope, authentication);
        session.setAttribute(SecurityService.AuthenticationContext.class.getName(), (Object)authorizationContext);
    }

    public Principal login(Object credentials, String charset) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials, charset);
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        Principal principal = null;
        if (graniteContext instanceof HttpGraniteContext) {
            HttpServletRequest httpRequest = graniteContext.getRequest();
            Request request = (Request)httpRequest;
            Authentication authentication = request.getAuthentication();
            UserIdentity.Scope scope = request.getUserIdentityScope();
            Jetty9AuthenticationContext authenticationContext = new Jetty9AuthenticationContext(scope, authentication);
            principal = authenticationContext.authenticate(decoded[0], decoded[1]);
            if (principal != null) {
                graniteContext.getSession().setAttribute(SecurityService.AuthenticationContext.class.getName(), (Object)authenticationContext);
            }
        } else {
            SecurityService.AuthenticationContext authenticationContext = (SecurityService.AuthenticationContext)graniteContext.getSession().getAttribute(SecurityService.AuthenticationContext.class.getName());
            if (authenticationContext != null) {
                principal = authenticationContext.authenticate(decoded[0], decoded[1]);
            } else {
                return null;
            }
        }
        if (principal == null) {
            throw SecurityServiceException.newInvalidCredentialsException((String)"Wrong username or password");
        }
        graniteContext.setPrincipal(principal);
        this.endLogin(credentials, charset);
        return principal;
    }

    public Object authorize(AbstractSecurityContext context) throws Exception {
        HttpSession session;
        this.startAuthorization(context);
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = null;
        SecurityService.AuthenticationContext authenticationContext = null;
        Principal principal = null;
        if (graniteContext instanceof HttpGraniteContext) {
            httpRequest = graniteContext.getRequest();
            session = httpRequest.getSession(false);
            if (session != null) {
                Request request;
                Authentication authentication;
                authenticationContext = (SecurityService.AuthenticationContext)session.getAttribute(SecurityService.AuthenticationContext.class.getName());
                if (authenticationContext != null) {
                    principal = authenticationContext.getPrincipal();
                    ((Request)httpRequest).setAuthentication(((Jetty9AuthenticationContext)authenticationContext).getAuthentication());
                }
                if (principal == null && this.tryRelogin() && (authentication = (request = (Request)httpRequest).getAuthentication()) instanceof Authentication.User) {
                    principal = ((Authentication.User)authentication).getUserIdentity().getUserPrincipal();
                }
            }
        } else {
            session = graniteContext.getSession(false);
            if (session != null && (authenticationContext = (SecurityService.AuthenticationContext)session.getAttribute(SecurityService.AuthenticationContext.class.getName())) != null) {
                principal = authenticationContext.getPrincipal();
            }
        }
        graniteContext.setPrincipal(principal);
        if (context.getDestination().isSecured()) {
            if (principal == null) {
                HttpSession httpSession;
                if (!(httpRequest == null || httpRequest.getRequestedSessionId() == null || (httpSession = httpRequest.getSession(false)) != null && httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                    throw SecurityServiceException.newSessionExpiredException((String)"Session expired");
                }
                throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
            }
            if (httpRequest == null && authenticationContext == null) {
                throw SecurityServiceException.newNotLoggedInException((String)"No authorization context");
            }
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (httpRequest != null && httpRequest.isUserInRole(role)) {
                    accessDenied = false;
                    break;
                }
                if (authenticationContext == null || !authenticationContext.isUserInRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException((String)"User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (!(t instanceof SecurityException)) continue;
                throw SecurityServiceException.newAccessDeniedException((String)t.getMessage());
            }
            throw e;
        }
    }

    public void logout() throws SecurityServiceException {
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        if (graniteContext instanceof HttpGraniteContext) {
            Request request = (Request)graniteContext.getRequest();
            Authentication authentication = request.getAuthentication();
            if (authentication instanceof Authentication.User) {
                ((Authentication.User)authentication).logout();
            }
            if (request.getSession(false) != null) {
                this.endLogout();
                request.getSession(false).invalidate();
            }
        } else {
            HttpSession session = graniteContext.getSession();
            if (session != null) {
                SecurityService.AuthenticationContext authenticationContext = (SecurityService.AuthenticationContext)session.getAttribute(SecurityService.AuthenticationContext.class.getName());
                authenticationContext.logout();
                session.removeAttribute(SecurityService.AuthenticationContext.class.getName());
                this.endLogout();
                session.invalidate();
            }
        }
    }

    public static class Jetty9AuthenticationContext
    implements SecurityService.AuthenticationContext {
        private static final long serialVersionUID = 1L;
        private final transient UserIdentity.Scope scope;
        private transient Authentication authentication;
        private transient Principal principal;

        public Jetty9AuthenticationContext(UserIdentity.Scope scope, Authentication authentication) {
            this.scope = scope;
            this.authentication = authentication;
        }

        public Principal authenticate(String username, String password) {
            if (this.authentication == null) {
                throw SecurityServiceException.newAuthenticationFailedException((String)"Invalid authentication");
            }
            if (this.authentication instanceof Authentication.Deferred) {
                this.authentication = ((Authentication.Deferred)this.authentication).login(username, (Object)password, (ServletRequest)((ServletGraniteContext)GraniteContext.getCurrentInstance()).getRequest());
            }
            if (this.authentication instanceof Authentication.User) {
                this.principal = ((Authentication.User)this.authentication).getUserIdentity().getUserPrincipal();
            }
            return this.principal;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public boolean isUserInRole(String role) {
            if (this.authentication instanceof Authentication.User) {
                return ((Authentication.User)this.authentication).isUserInRole(this.scope, role);
            }
            return false;
        }

        public void logout() {
            if (this.authentication instanceof Authentication.User) {
                ((Authentication.User)this.authentication).logout();
            }
        }
    }
}

