/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam21;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.granite.tide.seam.AbstractSeamServiceContext;
import org.granite.tide.seam.TideInvocation;
import org.granite.tide.seam.async.AsyncContext;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.async.AbstractDispatcher;
import org.jboss.seam.async.Dispatcher;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;

@Name(value="org.jboss.seam.core.events")
@Install(precedence=11)
@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@AutoCreate
public class TideEvents
extends Events {
    @Logger
    protected Log log;
    protected static final String ASYNC_EVENT = "org.granite.tide.seam.AsyncEvent";
    private static final Class<?>[] SEAM21_TIMED_EVENT_ARGS = new Class[]{String.class, Schedule.class, Object[].class};

    public void raiseEvent(String type, Object ... parameters) {
        if (ASYNC_EVENT.equals(type)) {
            TideInvocation.init();
            AbstractSeamServiceContext serviceContext = (AbstractSeamServiceContext)((Object)Component.getInstance((String)"org.granite.tide.seam.serviceContext", (boolean)true));
            WrappedEvent event = (WrappedEvent)parameters[0];
            serviceContext.setAsyncContext(event.getAsyncContext());
            this.raiseEvent(event.getType(), event.getParams());
            serviceContext.sendEvent(null, null);
        } else {
            AbstractSeamServiceContext serviceContext;
            super.raiseEvent(type, parameters);
            if (!type.startsWith("org.jboss.seam.pre") && !type.startsWith("org.jboss.seam.post") && (serviceContext = (AbstractSeamServiceContext)((Object)Component.getInstance((String)"org.granite.tide.seam.serviceContext", (boolean)false))) != null) {
                serviceContext.raiseEvent(type, parameters);
            }
        }
    }

    public void raiseAsynchronousEvent(String type, Object ... parameters) {
        String sessionId;
        AbstractSeamServiceContext serviceContext = (AbstractSeamServiceContext)((Object)Component.getInstance((String)"org.granite.tide.seam.serviceContext", (boolean)false));
        String string = sessionId = serviceContext != null ? serviceContext.getSessionId() : null;
        if (serviceContext != null && sessionId != null) {
            super.raiseAsynchronousEvent(ASYNC_EVENT, new Object[]{new WrappedEvent(serviceContext.getAsyncContext(), type, parameters)});
        } else {
            super.raiseAsynchronousEvent(type, parameters);
        }
    }

    public void raiseTimedEvent(String type, Schedule schedule, Object ... parameters) {
        AbstractSeamServiceContext serviceContext = (AbstractSeamServiceContext)((Object)Component.getInstance((String)"org.granite.tide.seam.serviceContext", (boolean)false));
        String sessionId = serviceContext != null ? serviceContext.getSessionId() : null;
        Dispatcher dispatcher = AbstractDispatcher.instance();
        if (dispatcher != null) {
            try {
                Method m = dispatcher.getClass().getMethod("scheduleTimedEvent", SEAM21_TIMED_EVENT_ARGS);
                if (serviceContext != null && sessionId != null) {
                    m.invoke((Object)dispatcher, ASYNC_EVENT, schedule, new Object[]{new WrappedEvent(serviceContext.getAsyncContext(), type, parameters)});
                } else {
                    m.invoke((Object)dispatcher, type, schedule, parameters);
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Could not raise timed event", (Throwable)e, new Object[0]);
            }
        }
    }

    protected static class WrappedEvent
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AsyncContext asyncContext;
        private String type;
        private Object[] params;

        public WrappedEvent(AsyncContext asyncContext, String type, Object[] params) {
            this.asyncContext = asyncContext;
            this.type = type;
            this.params = params;
        }

        public AsyncContext getAsyncContext() {
            return this.asyncContext;
        }

        public String getType() {
            return this.type;
        }

        public Object[] getParams() {
            return this.params;
        }
    }
}

