/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.annotations.BypassTideInterceptor;
import org.granite.tide.invocation.ContextUpdate;
import org.granite.tide.seam.AbstractSeamServiceContext;
import org.granite.tide.seam.ScopedContextResult;
import org.granite.tide.seam.SeamUtils;
import org.granite.tide.seam.TideDataModel;
import org.granite.tide.seam.TideInit;
import org.granite.tide.seam.TideInvocation;
import org.granite.tide.seam.lazy.SeamInitializer;
import org.granite.tide.seam.lazy.TidePersistenceFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.DataBinderClass;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.bpm.BusinessProcessInterceptor;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.BijectionInterceptor;
import org.jboss.seam.core.EventInterceptor;
import org.jboss.seam.databinding.DataBinder;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Interceptor(around={BijectionInterceptor.class, EventInterceptor.class, BusinessProcessInterceptor.class})
public class TideInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private static final LogProvider log = Logging.getLogProvider(TideInterceptor.class);
    private boolean reentrant;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        if (this.reentrant) {
            log.trace((Object)"About to invoke method");
            if (log.isTraceEnabled()) {
                log.trace((Object)("reentrant call to component: " + this.getComponent().getName()));
            }
            Object result = invocation.proceed();
            log.trace((Object)"Method invoked");
            return result;
        }
        this.reentrant = true;
        try {
            Set<TideInit.FactoryVariable> factoredVariables;
            ScopeType scope;
            if (this.getComponent().getBeanClass().isAnnotationPresent(BypassTideInterceptor.class)) {
                Object result = invocation.proceed();
                return result;
            }
            TideInvocation tideInvocation = TideInvocation.get();
            if (tideInvocation == null || tideInvocation.isLocked()) {
                Object object = invocation.proceed();
                return object;
            }
            AbstractSeamServiceContext tideContext = null;
            if (Contexts.isSessionContextActive()) {
                tideContext = (AbstractSeamServiceContext)((Object)Component.getInstance((String)"org.granite.tide.seam.serviceContext", (boolean)true));
            }
            if (tideContext == null) {
                Object object = invocation.proceed();
                return object;
            }
            if (SeamUtils.isLifecycleMethod(this.getComponent(), invocation.getMethod())) {
                tideInvocation.lock();
                Object result = invocation.proceed();
                tideInvocation.unlock();
                Object object = result;
                return object;
            }
            boolean evaluate = false;
            this.checkForPersistenceContexts(invocation);
            if (tideInvocation.isEnabled() && !tideInvocation.isUpdated()) {
                ArrayList<ContextUpdate> updates = new ArrayList<ContextUpdate>(tideInvocation.getUpdates());
                tideInvocation.updated();
                tideContext.restoreContext(updates, this.getComponent(), invocation.getTarget());
                evaluate = true;
                Field field = this.getComponent().getClass().getDeclaredField("dataModelGetters");
                field.setAccessible(true);
                List dataModelGetters = (List)field.get(this.getComponent());
                for (Component.BijectedAttribute getter : dataModelGetters) {
                    Object dataModel;
                    Annotation dataModelAnn = getter.getAnnotation();
                    DataBinder wrapper = (DataBinder)dataModelAnn.annotationType().getAnnotation(DataBinderClass.class).value().newInstance();
                    String name = getter.getName();
                    ScopeType scope2 = wrapper.getVariableScope(dataModelAnn);
                    if (scope2 == ScopeType.UNSPECIFIED && (scope2 = this.getComponent().getScope()) == ScopeType.STATELESS) {
                        scope2 = ScopeType.EVENT;
                    }
                    if ((dataModel = scope2.getContext().get(name)) == null || !(dataModel instanceof TideDataModel)) continue;
                    Field field2 = this.getComponent().getClass().getDeclaredField("dataModelSelectionSetters");
                    field2.setAccessible(true);
                    Map setters = (Map)field2.get(this.getComponent());
                    Component.BijectedAttribute setter = (Component.BijectedAttribute)setters.get(name);
                    if (setter == null) continue;
                    Object value = setter.get(invocation.getTarget());
                    ((TideDataModel)dataModel).setRowData(value);
                }
            }
            Object result = invocation.proceed();
            boolean restrict = this.getComponent().beanClassHasAnnotation(Restrict.class);
            if (this.getComponent().needsOutjection()) {
                List li = this.getComponent().getOutAttributes();
                for (Component.BijectedAttribute att : li) {
                    Context context;
                    scope = ((Out)att.getAnnotation()).scope();
                    if (ScopeType.UNSPECIFIED.equals((Object)scope)) {
                        Component outComponent = Component.forName((String)att.getName());
                        scope = outComponent != null ? outComponent.getScope() : this.getComponent().getScope();
                    }
                    if (ScopeType.STATELESS.equals((Object)scope)) {
                        scope = ScopeType.EVENT;
                    }
                    if (!ScopeType.EVENT.equals((Object)scope) && (context = Contexts.getEventContext()).get(att.getName() + "_tide_unspecified_") != null) {
                        context.remove(att.getName() + "_tide_unspecified_");
                        context.remove(att.getName());
                    }
                    tideContext.addResultEval(new ScopedContextResult(att.getName(), null, scope, restrict));
                }
                Field field = this.getComponent().getClass().getDeclaredField("dataModelGetters");
                field.setAccessible(true);
                List dataModelGetters = (List)field.get(this.getComponent());
                for (Component.BijectedAttribute getter : dataModelGetters) {
                    Context context;
                    Annotation anno = getter.getAnnotation();
                    DataBinder wrapper = (DataBinder)anno.annotationType().getAnnotation(DataBinderClass.class).value().newInstance();
                    ScopeType scope3 = wrapper.getVariableScope(anno);
                    if (ScopeType.UNSPECIFIED.equals((Object)scope3)) {
                        scope3 = this.getComponent().getScope();
                    }
                    if (ScopeType.STATELESS.equals((Object)scope3)) {
                        scope3 = ScopeType.EVENT;
                    }
                    if (!ScopeType.EVENT.equals((Object)scope3) && (context = Contexts.getEventContext()).get(getter.getName() + "_tide_unspecified_") != null) {
                        context.remove(getter.getName() + "_tide_unspecified_");
                        context.remove(getter.getName());
                    }
                    tideContext.addResultEval(new ScopedContextResult(getter.getName(), null, scope3, restrict));
                }
            }
            if ((factoredVariables = TideInit.getFactoredVariables(this.getComponent())) != null) {
                for (TideInit.FactoryVariable variable : factoredVariables) {
                    scope = variable.getScope();
                    if (ScopeType.UNSPECIFIED.equals((Object)scope)) {
                        scope = this.getComponent().getScope();
                    }
                    if (ScopeType.STATELESS.equals((Object)scope)) {
                        scope = ScopeType.EVENT;
                    }
                    tideContext.addResultEval(new ScopedContextResult(variable.getVariableName(), null, scope, restrict));
                }
            }
            if (evaluate) {
                tideInvocation.evaluated(tideContext.evaluateResults(this.getComponent(), invocation.getTarget(), false));
            }
            Object object = result;
            return object;
        }
        finally {
            this.reentrant = false;
        }
    }

    private void checkForPersistenceContexts(InvocationContext ctx) {
        Object bean = ctx.getTarget();
        TidePersistenceManager pm = null;
        Iterator i$ = this.getComponent().getPersistenceContextAttributes().iterator();
        if (i$.hasNext()) {
            Component.BijectedAttribute ba = (Component.BijectedAttribute)i$.next();
            Object object = ba.get(bean);
            SeamInitializer.instance().setTidePersistenceManager(TidePersistenceFactory.createTidePersistence(this.getComponent(), object));
            return;
        }
        if (this.getComponent().needsInjection()) {
            List li = this.getComponent().getInAttributes();
            for (Component.BijectedAttribute att : li) {
                try {
                    pm = TidePersistenceFactory.createTidePersistence(this.getComponent(), (Component.BijectedAttribute<In>)att);
                }
                catch (RuntimeException ex) {
                    continue;
                }
                if (pm == null) continue;
                SeamInitializer.instance().setTidePersistenceManager(pm);
                return;
            }
        }
        if ((pm = TidePersistenceFactory.createTidePersistence(this.getComponent(), ctx.getTarget())) != null) {
            SeamInitializer.instance().setTidePersistenceManager(pm);
        }
    }

    public boolean isInterceptorEnabled() {
        return true;
    }
}

