/*
 * Decompiled with CFR 0.152.
 */
package org.granite.seam;

import flex.messaging.messages.RemotingMessage;
import org.granite.config.flex.Destination;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.seam.SeamServiceInvoker;
import org.granite.util.XMap;
import org.jboss.seam.Component;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public class SeamServiceFactory
extends ServiceFactory {
    private static final Log log = Logging.getLog(SeamServiceFactory.class);

    public void configure(XMap properties) throws ServiceException {
        super.configure(properties);
    }

    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        ServicesConfig config = (ServicesConfig)GraniteContext.getCurrentInstance().getServicesConfig();
        Destination destination = config.findDestinationById(messageType, destinationId);
        if (destination == null) {
            throw new ServiceException("No matching destination: " + destinationId);
        }
        String componentName = destination.getProperties().get("source");
        Component component = Component.forName((String)componentName);
        if (component == null) {
            String msg = "Unable to create a Seam component named [" + componentName + "]";
            log.error((Object)msg, new Object[0]);
            ServiceException e = new ServiceException(msg);
            throw e;
        }
        Object instance = Component.getInstance((String)componentName, (boolean)true);
        return new SeamServiceInvoker(destination, this, instance);
    }
}

