/*
 * Decompiled with CFR 0.152.
 */
package org.granite.seam21.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.international.StatusMessages;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.NotLoggedInException;

public class Seam21SecurityService
extends AbstractSecurityService {
    private static final Logger log = Logger.getLogger(Seam21SecurityService.class);

    public void configure(Map<String, String> params) {
    }

    public Principal login(Object credentials, String charset) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials, charset);
        Contexts.getSessionContext().set("org.granite.seam.login", (Object)Boolean.TRUE);
        Identity identity = Identity.instance();
        if (identity.isLoggedIn(false) && !decoded[0].equals(identity.getUsername())) {
            try {
                Method method = identity.getClass().getDeclaredMethod("unAuthenticate", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)identity, new Object[0]);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Could not call unAuthenticate method on: %s", new Object[]{identity.getClass()});
            }
        }
        identity.setUsername(decoded[0]);
        identity.setPassword(decoded[1]);
        try {
            identity.authenticate();
            this.endLogin(credentials, charset);
        }
        catch (LoginException e) {
            try {
                Method method = identity.getClass().getMethod("getCredentials", new Class[0]);
                Object cred = method.invoke((Object)identity, new Object[0]);
                method = cred.getClass().getMethod("invalidate", new Class[0]);
                method.invoke(cred, new Object[0]);
            }
            catch (Exception f) {
                log.error((Throwable)f, "Could not call getCredentials().invalidate() method on: %s", new Object[]{identity.getClass()});
            }
            if (Events.exists()) {
                Events.instance().raiseEvent("org.jboss.seam.security.loginFailed", new Object[]{e});
            }
            throw SecurityServiceException.newInvalidCredentialsException((String)"User authentication failed");
        }
        return identity.getPrincipal();
    }

    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        if (context.getDestination().isSecured()) {
            Identity identity = Identity.instance();
            if (!identity.isLoggedIn()) {
                throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
            }
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (!identity.hasRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException((String)"User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (t instanceof NotLoggedInException) {
                    throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
                }
                if (!(t instanceof SecurityException) && !(t instanceof AuthorizationException) && !"javax.ejb.EJBAccessException".equals(t.getClass().getName())) continue;
                throw SecurityServiceException.newAccessDeniedException((String)t.getMessage());
            }
            throw e;
        }
    }

    public void logout() throws SecurityServiceException {
        Identity.instance().logout();
    }

    public void handleSecurityException(SecurityServiceException e) {
        List messages = Collections.emptyList();
        try {
            StatusMessages statusMessages = StatusMessages.instance();
            if (statusMessages != null) {
                Method m = StatusMessages.class.getDeclaredMethod("doRunTasks", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)statusMessages, new Object[0]);
                Method m2 = StatusMessages.class.getDeclaredMethod("getMessages", new Class[0]);
                m2.setAccessible(true);
                messages = (List)m2.invoke((Object)statusMessages, new Object[0]);
            }
        }
        catch (Exception se) {
            log.error("Could not get status messages", new Object[]{se});
        }
        ArrayList tideMessages = new ArrayList(messages.size());
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass("org.granite.tide.TideMessage");
            Constructor<?> co = c.getConstructor(String.class, String.class, String.class);
            for (StatusMessage fm : messages) {
                String severity = null;
                if (fm.getSeverity() == StatusMessage.Severity.INFO) {
                    severity = "INFO";
                } else if (fm.getSeverity() == StatusMessage.Severity.WARN) {
                    severity = "WARNING";
                } else if (fm.getSeverity() == StatusMessage.Severity.ERROR) {
                    severity = "ERROR";
                } else if (fm.getSeverity() == StatusMessage.Severity.FATAL) {
                    severity = "FATAL";
                }
                tideMessages.add(co.newInstance(severity, fm.getSummary(), fm.getDetail()));
            }
            e.getExtendedData().put("messages", tideMessages);
        }
        catch (Throwable t) {
            e.getExtendedData().put("messages", tideMessages);
        }
    }
}

