/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.tomcat.TomcatWebSocketChannelFactory;
import org.granite.gravity.websocket.AbstractWebSocketChannel;
import org.granite.logging.Logger;

public class TomcatWebSocketChannel
extends AbstractWebSocketChannel {
    private static final Logger log = Logger.getLogger(TomcatWebSocketChannel.class);
    private StreamInbound streamInbound = new MessageInboundImpl();
    private WsOutbound connection;

    public TomcatWebSocketChannel(GravityInternal gravity, String id, TomcatWebSocketChannelFactory factory, String clientType) {
        super(gravity, id, (ChannelFactory)factory, clientType);
        this.setMaxBinaryMessageBufferSize(this.streamInbound.getOutboundByteBufferSize());
    }

    public StreamInbound getStreamInbound() {
        return this.streamInbound;
    }

    protected boolean isConnected() {
        return this.connection != null;
    }

    protected void sendBytes(byte[] msg) throws IOException {
        this.connection.writeBinaryMessage(ByteBuffer.wrap(msg));
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close(1000, ByteBuffer.wrap("Channel closed".getBytes()));
            }
            catch (IOException e) {
                log.error("Could not close WebSocket connection", new Object[]{e});
            }
            this.connection = null;
        }
    }

    public class MessageInboundImpl
    extends MessageInbound {
        protected void onOpen(WsOutbound outbound) {
            TomcatWebSocketChannel.this.connection = outbound;
            TomcatWebSocketChannel.this.connect();
        }

        public void onClose(int closeCode) {
            log.debug("WebSocket connection onClose %d", new Object[]{closeCode});
            TomcatWebSocketChannel.this.connection = null;
        }

        public void onBinaryMessage(ByteBuffer buf) {
            byte[] data = buf.array();
            TomcatWebSocketChannel.this.receiveBytes(data, 0, data.length);
        }

        protected void onTextMessage(CharBuffer buf) throws IOException {
            log.warn("Channel %s unsupported text message", new Object[]{TomcatWebSocketChannel.this.getId()});
        }
    }
}

